#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <unistd.h>
#include <fcntl.h>
#include "mpt1327.h"
#include "serial.h"

#define MPT1327_POLYNOM 0x6815


#define TARGET_PREFIX 0xffff     /* Target Prefix - 0xffff to track all */ 
#define TARGET_IDENT 0xffff     /* Target Ident to Track - 0xffff to track all idents within prefix */

#define VERBOSE 0    /* Verbose mode - show extra information for debugging */


double baseFreq;
double offset;
double step;
double control;
double filt;
double verb;
double track;
double sound;
double logger;
unsigned short trg_pre;
unsigned short trg_id;
int portadr;
int portspeed;
double rx;
double rxa;
unsigned short rxb;
unsigned short rxc;
unsigned short rxd;
unsigned short rxe;
unsigned short rxf;



int sysprint=0;
char sys[7]="0xffff";
unsigned short currentsys=0xffff;                   
char sysname[255];
int removemsg=FALSE;
char ptext[255];

FILE *log = NULL;



void pprint (char *msg){
unsigned  int idx;

  if (!memcmp(msg,"ALO",3)||!memcmp(msg,"REQ",3)||!memcmp(msg,"MIS",3)){
    if (removemsg){
      printf("          ");
      for(idx=0;idx<10;idx++) printf("%c",0x08);
      removemsg=FALSE;
    }
    else {    printf("%s       ",msg);
      for(idx=0;idx<(strlen(msg)+7);idx++) printf("%c",0x08);
      removemsg=TRUE;
    }
  }
  else{
    removemsg=FALSE;
    if (!memcmp(msg,"SYS",3) && !sysprint){
      sysprint=1;
      printf(msg);
      if(logger==1) fprintf(log,msg);
    }
    else
      if (memcmp(msg,"SYS",3)){
        printf("%s\n",msg);
        if(logger==1) fprintf(log,"%s\n",msg);
        sysprint=0;
      }
  }
  fflush(log);
}
//----------------------------------------------------------------------------
void printbins(unsigned short x)
{
  int n;
  printf("   ");
  fprintf(log," ");
  for (n=0; n<16; n++)
  {
      if ((x & 0x8000) !=0) {
       printf("1");
       fprintf(log,"1");
      }
      else { 
       printf("0");
       fprintf(log,"0");
      }
      
      if (n==7) { 
       printf(" ");
       fprintf(log," ");
      }
      x = x<<1;
  }
  fflush(log);
}
//-----------------------------------------------------------------------------

void mpt1327_setup(void)
{
	char CurrDir[MAX_PATH];
 
 	GetCurrentDirectory(MAX_PATH,CurrDir);
	strcat(CurrDir,"\\vbtrunk.ini");
    
    filt=(double)GetPrivateProfileInt("general","FILTER",0,CurrDir);
    verb=(double)GetPrivateProfileInt("general","BINARY",0,CurrDir);
    track=(double)GetPrivateProfileInt("general","TRACK",0,CurrDir);
    sound=(double)GetPrivateProfileInt("general","BEEP",0,CurrDir);
    logger=(double)GetPrivateProfileInt("general","LOG",0,CurrDir);
    trg_pre=(unsigned short)GetPrivateProfileInt("general","TARGET_PREF",0,CurrDir);
    trg_id=(unsigned short)GetPrivateProfileInt("general","TARGET_ID",0,CurrDir);
    baseFreq = ((double)GetPrivateProfileInt(sys,"BEGINOFBAND",4200000,CurrDir) / 10000.0);
	offset = (double)GetPrivateProfileInt(sys,"OFFSET",2,CurrDir);
	step = ((double)GetPrivateProfileInt(sys,"STEP",125,CurrDir) / 10000.0);
	control = ((double)GetPrivateProfileInt(sys,"CCHFREQUENCY",4200000,CurrDir) / 10000.0);
	portadr = (int)GetPrivateProfileInt("rs232","PORTADR",1,CurrDir);
	portspeed = (int)GetPrivateProfileInt("rs232","PORTSPEED",9600,CurrDir);
	rx = (double)GetPrivateProfileInt("rs232","RADIO",1,CurrDir);
	GetPrivateProfileString(sys,"NAME","Unregistered",sysname,sizeof(sysname),CurrDir);
	
	
      if (!log&&logger==1){
      log=fopen("logfile.txt","at");
      time_t t = time(NULL);
      sprintf(ptext,"\n  === Tronkito - MPT1327 Trunking-Decoder - DF1VB ===  %s",ctime(&t));
      pprint(ptext);
      }
 }

static int
getbit(int n, unsigned short *codewords)
{
    unsigned short mask;
    unsigned short codeword;

    codeword = codewords[n/16];
    mask = 1<<(15-(n%16));

    return (codeword & mask)?1:0;
}


static unsigned short
mpt1327_fcs(mpt1327_t *m)
{
    int n, bit;
    unsigned short syndrome = 0, parity = 0;

    for (n = 0; n < 64; n++) {
	bit = getbit(n, m->codeword);
	parity ^= bit;
	if (n == 62) bit ^= 1;
	if (n < 63) {
	    syndrome <<= 1;
	    if (bit ^ ((syndrome & 0x8000)?1:0))
		syndrome ^= 0x6815;
	}
    }

    syndrome &= 0x7fff;
    if (parity)
	syndrome |= 0x8000;
    
    return syndrome;
}



void
mpt1327(unsigned char bit, mpt1327_t *m)
{
    unsigned short para;
    unsigned char beep=7;
    unsigned short channel;
    unsigned short channelc;
    double channel2;         
    unsigned short prefix;        
    unsigned short prefix2;
    unsigned short ident1;
    unsigned short ident2;
    unsigned short wt;
    unsigned short rsvd;
    unsigned short alm;
    unsigned short aln;
    unsigned short sysdef;
    unsigned short sysid;
    unsigned short cat;
    unsigned short type;
    unsigned short func;

    /*
     * Shift in the least significant bit into the 64 bit frame.
     */
    m->codeword[0] <<= 1;
    m->codeword[0] += (m->codeword[1] & 0x8000)?1:0;
    m->codeword[1] <<= 1;
    m->codeword[1] += (m->codeword[2] & 0x8000)?1:0;
    m->codeword[2] <<= 1;
    m->codeword[2] += (m->codeword[3] & 0x8000)?1:0;
    m->codeword[3] <<= 1;
    if (bit) m->codeword[3] += 1;
    m->cnt++;

    
    
    

    switch (m->state) {
    case 0:
    
	if (((m->codeword[3] & 0xffff) == MPT1327_SYNC) ||
	    ((m->codeword[3] & 0xffff) == MPT1327_SYNT)) {
	    if (mpt1327_fcs(m) == 0) {
#if 1

	    if (currentsys!=(m->codeword[0] & 0x7fff)){
	      currentsys=m->codeword[0] & 0x7fff;
	      sprintf(sys,"0x%4.4x",currentsys);
	      mpt1327_setup();
	      pprint("***************************    Protocol-Decoder    ***************************");

          // sprintf(ptext,"  SYS 0x%4.4x  | %s | CCh: %.4f MHz filter=%d\n******************************************************************************\n", m->codeword[0] & 0x7fff, sysname, control,trg_pre);       
          sprintf(ptext,"  SYS 0x%4.4x  | %s | CCh-Frequency: %.4f MHz\n******************************************************************************\n", m->codeword[0] & 0x7fff, sysname, control);
          pprint(ptext);
        }
// Protokolldecoder fuer Filter groesser 4
        
        if ((filt>4)&&((m->codeword[2]) == 0xaaaa)&&((m->codeword[3]) == 0xc4d7)&&(!((m->codeword[0]) >>15 & 0x1))){
          sprintf(ptext,"- CCSC | Control Channel System Codeword|   SYS Id: 0x%4.4x",(m->codeword[0] & 0x7fff));                   
          if (verb==1){printbins(m->codeword[0]);printbins(m->codeword[1]);printbins(m->codeword[2]);printbins(m->codeword[3]);}
          pprint(ptext);
        }
        if ((filt>4)&&((m->codeword[2]) == 0xaaaa)&&((m->codeword[3]) == 0x3b28)&&(!((m->codeword[0]) >>15 & 0x1))){
          sprintf(ptext,"- DCSC |  Data Channel Systm Codeword   |   SYS Id: 0x%4.4x",(m->codeword[0] & 0x7fff));                   
          if (verb==1){printbins(m->codeword[0]);printbins(m->codeword[1]);printbins(m->codeword[2]);printbins(m->codeword[3]);}
          pprint(ptext);
        }
        
        
#endif
	    }
	    m->state = 1;
	    m->cnt = 0;
	}
	break;
    case 1:
	if (m->cnt == 64) {
	    if (mpt1327_fcs(m) == 0) {
#if 0
		if (m->codeword[0] & 0x8000) {
		    printf("A ");                     /* Address Codeword */
		} else {
		    printf("D ");                     /* Data Codeword */
		}
#endif

                cat = ((m->codeword[1]>>7) & 0x7);
                type = ((m->codeword[1]>>5) & 0x3);
                func = ((m->codeword[1]>>2) & 0x7);

             
#if VERBOSE

			printf("CAT: 0x%1.1x ", (m->codeword[1]>>7) & 0x7);
			printf("TYPE: 0x%1.1x ", (m->codeword[1]>>5) & 0x3);
			printf("FUNC: 0x%1.1x ", (m->codeword[1]>>2) & 0x7);
			printf("\n");
#endif

                if (cat == 0x0) {
                  if (type == 0x0) pprint("ALOHA");
                  if (type == 0x0 && filt>3){
                  printf("- ALOHA");
                    sprintf(ptext,"- ");
                    if (func == 0x0) strcat(ptext," ALH | General single Codeword        |");
                    if (func == 0x1) strcat(ptext,"ALHS | Messages invited, except RQD   |");
                    if (func == 0x2) strcat(ptext,"ALHD | Messages invited, except RQS   |");
                    if (func == 0x3) strcat(ptext,"ALHE | Emergency requests (RQE) only  |");
                    if (func == 0x4) strcat(ptext,"ALHR | Registration/Emergency request |");
                    if (func == 0x5) strcat(ptext,"ALHX | Messages invited, except RQR   |");
                    if (func == 0x6) strcat(ptext,"ALHF | Fall-back mode                 |");
                    if (func == 0x7) strcat(ptext,"ALH? | Reserved                       |");
                    prefix = ((m->codeword[0] & 0x7f00) >> 8);
                    ident1 = ((m->codeword[0] << 5 | m->codeword[1] >> 11) & 0x1fff);
                    wt = ((m->codeword[2] >> 11) & 0x7) ;
                    rsvd = ((m->codeword[2] >> 9) & 0x3) ;
                    alm = ((m->codeword[2] >> 4) & 0x1f) ;
                    aln = ((m->codeword[2]) & 0xf) ;
                    
                    sprintf(ptext,"%s (%d) Id:%d WT:%d RSVD:%d M:%d N:%d",ptext,prefix,ident1,wt,rsvd,alm,aln);
                    if (verb==1){printbins(m->codeword[0]);printbins(m->codeword[1]);printbins(m->codeword[2]);printbins(m->codeword[3]);}
                    pprint(ptext);
                    
                  }
                                                      
                  if (filt>0 && (type == 0x1)) {
                    sprintf(ptext,"- ACK");
                    if (func == 0x0) strcat(ptext,"K | General acknowledgement        |");
                    if (func == 0x1) strcat(ptext,"I | Intermediate ack, more follows |");
                    if (func == 0x2) strcat(ptext,"Q | Acknowledge, call queued :-(   |");
                    if (func == 0x3) strcat(ptext,"X | Acknowledge, message rejected  |");
                    if (func == 0x4) strcat(ptext,"V | Acknowledge, unit unavailable  |");
                    if (func == 0x5) strcat(ptext,"E |* Acknowledge, emergency call * |");
                    if (func == 0x6) strcat(ptext,"T | Acknowledge, try given address |");
                    if (func == 0x7) strcat(ptext,"B |Acknowledge, call-back or negat.|");

#
                    prefix = ((m->codeword[0] & 0x7f00) >> 8);
                    ident1 = ((m->codeword[0] << 5 | m->codeword[1] >> 11) & 0x1fff);
                    ident2 = ((m->codeword[1] << 11 | m->codeword[2] >> 5) & 0x1fff);
                    sprintf(ptext,"%s (%3d)  Org: %4d       Tar: %4d",ptext,prefix,ident2,ident1);
                    if (verb==1){printbins(m->codeword[0]);printbins(m->codeword[1]);printbins(m->codeword[2]);printbins(m->codeword[3]);}
                    pprint(ptext);
                  }
                  
                  if (type == 0x2) pprint("REQ / AHOY");
                  if (type == 0x2 && filt>2){        
                    prefix = ((m->codeword[0] & 0x7f00) >> 8);
                    ident1 = ((m->codeword[0] << 5 | m->codeword[1] >> 11) & 0x1fff);
                    ident2 = ((m->codeword[1] << 11 | m->codeword[2] >> 5) & 0x1fff);
                    rsvd = ((m->codeword[2] >> 3) & 0x3); // RQC slots
                    sprintf(ptext,"-  ");
                    if (func == 0x0){
                     sprintf(ptext,"%sRQS | Request random access          | (%3d)  Org: %4d  Tar: %4d",ptext,prefix,ident2,ident1);
                     if ((m->codeword[2]) >>4 & 0x1){  // DT
                       strcat(ptext," Voice");
                     }
                     else{
                       strcat(ptext," Data");
                     }
                     if (!(m->codeword[2]) >>3 & 0x1) strcat(ptext," Priority");
                     sprintf(ptext,"%s\n   AHY | Availability check message     | Begin Ack a: ",ptext);
                     if ((m->codeword[2]) >>3 & 0x1){ // point
                     sprintf(ptext,"%s(%d) Org:%d",ptext,prefix,ident2);
                     }
                     else{
                     sprintf(ptext,"%s(%d) Tar:%d",ptext,prefix,ident1);
                     }
                     if ((m->codeword[2]) >>4 & 0x1){  // D
                       strcat(ptext," Voice");
                     }
                     else{
                       strcat(ptext," Data");
                     }
                     if ((m->codeword[2]) >>1 & 0x1) strcat(ptext," Emergency");
                    } 
                    if (func == 0x1){ 
                    strcat(ptext,"RQ  | REQ dedicated                  |");
                    
                    }
                    if (func == 0x2){ 
                    sprintf(ptext,"%sRQX | Request call cancel/abort      | (%3d)  Org: %4d       Tar: %4d",ptext,prefix,ident2,ident1);
                    sprintf(ptext,"%s\n  AHYX | Cancel alert/waiting state     | (%3d)  Org: %4d       Tar: %4d",ptext,prefix,ident2,ident1);
                    }
                    if (func == 0x3){ 
                    strcat(ptext,"RQT | ");
                    if ((m->codeword[2]) >>2 & 0x1){  //DIV
                    strcat(ptext,"Cancel");
                    }
                    else{
                    strcat(ptext,"Request");
                    }
                    sprintf(ptext,"%s Request call diversion | (%3d) Org: %4d  Tar: %4d",ptext,prefix,ident2,ident1);
                     if ((m->codeword[2]) >>4 & 0x1){  // DT
                       strcat(ptext," Voice");
                     }
                     else{
                       strcat(ptext," Data");
                     }
                     if (!(m->codeword[2]) >>3 & 0x1) strcat(ptext," Vorrang");
                    }
                    if (func == 0x4){ 
                     sprintf(ptext,"%sRQE | Request emergency call         | (%3d)  Org: %4d  Tar: %4d ",ptext,prefix,ident2,ident1);
                     if ((m->codeword[2]) >>4 & 0x1){  // DT
                       strcat(ptext," Voice");
                     }
                     else{
                       strcat(ptext," Data");
                     }
                    }
                    if (func == 0x5){ 
                    sprintf(ptext,"%sRQR | Request to register            | (%3d)  Org: %4d",ptext,prefix,ident1);
                    sprintf(ptext,"%s\n  AHYP | Called Unit Presence Monitoring| (%3d)  Org: %4d Tar: %4d",ptext,prefix,ident2,ident1);
                    }
                    if (func == 0x6){ 
                    sprintf(ptext,"%sRQQ | Request status transaction     | (%3d)  Org: %4d       Tar: %4d",ptext,prefix,ident2,ident1);
                    sprintf(ptext,"%s\n  AHYQ | Status message                 | (%3d)  Org: %4d       Tar: %4d",ptext,prefix,ident2,ident1);
                    }
                    if (func == 0x7){ 
                    sprintf(ptext,"%sRQC | Request to send short data mess| (%3d)  Org: %4d  Tar: %4d  Slots:%d",ptext,prefix,ident2,ident1,rsvd);
                    sprintf(ptext,"%s\n  AHYC | Short data invitation message  | (%3d)  Org: %4d  Tar: %4d  Slots:%d",ptext,prefix,ident2,ident1,rsvd);
                    }
                    

                    if (verb==1){printbins(m->codeword[0]);printbins(m->codeword[1]);printbins(m->codeword[2]);printbins(m->codeword[3]);}
                    
                    pprint(ptext);
                                    
                  }
                  
                  
                  
                  if (type == 0x3) pprint("MISC");
                }

//Broadcast
                if (filt>1 && cat == 0x0 && type == 0x3 && func== 0x4) {
                   sysdef=((m->codeword[0] & 0x7c00) >> 10);
                   sysid=((m->codeword[0] << 5 | m->codeword[1] >> 11) & 0x7fff);
                   
                   switch (sysdef) {
                   case (0x0):
                   sprintf(ptext,"- BCAST| Control Channel Marker         |   Control Ch: %d   SYS: 0x%4.4x",((m->codeword[1] << 8 | m->codeword[2] >> 8) & 0x3ff),sysid);
                   break;
                   case (0x1):
                   sprintf(ptext,"- BCAST| Call clear-down                |   Control Ch: %d   SYS: 0x%4.4x",( (m->codeword[1] << 8 | m->codeword[2] >> 8) & 0x3ff),sysid);
                   break;
                   case (0x2):
                   sprintf(ptext,"- BCAST| Call maintenance               |   SYS: 0x%4.4x",sysid);                   
                   break;
                   case (0x3):
                   sprintf(ptext,"- BCAST| Registration Parameters        |   SYS: 0x%4.4x",sysid);                   
                   break;
                   case (0x4):
                   sprintf(ptext,"- BCAST| Neighbour Channel              |   Ch:  %d  Id red: %d  SYS: 0x%4.4x",( (m->codeword[1] << 8 | m->codeword[2] >> 8) & 0x3ff),(m->codeword[2] & 0xf),sysid);                   
                   break;
                   case (0x5):
                   sprintf(ptext,"- BCAST| Move Control Channel           |   Ch:  %d  Id red: %d  SYS: 0x%4.4x",((m->codeword[1] << 8 | m->codeword[2] >> 8) & 0x3ff),(m->codeword[2] & 0xf),sysid);                   
                   break;
                   default:
                   sprintf(ptext,"- BCAST| Reserved                       |   Sysdef: %d    SYS: 0x%4.4x",sysdef,sysid);
                   }                         
                   if (verb==1){printbins(m->codeword[0]);printbins(m->codeword[1]);printbins(m->codeword[2]);printbins(m->codeword[3]);}
                   pprint(ptext);



                }



                if (filt>0 && cat == 0x1 && type == 0x0) {
                 prefix = ((m->codeword[0] & 0x7f00) >> 8);
                 ident1 = ((m->codeword[0] << 5 | m->codeword[1] >> 11) & 0x1fff);
                 sprintf(ptext,"- SAM  | Single address messages        |    Group: (%d) Tar: (%d)",prefix,ident1);
                 if (verb==1){printbins(m->codeword[0]);printbins(m->codeword[1]);printbins(m->codeword[2]);printbins(m->codeword[3]);}
                 pprint(ptext);
                }

                if (filt>0 && cat == 0x1 && type == 0x1) {
                 prefix = ((m->codeword[0] & 0x7f00) >> 8);
                 ident1 = ((m->codeword[0] << 5 | m->codeword[1] >> 11) & 0x1fff);
                 prefix2 = ((m->codeword[1] | m->codeword[2] >> 13) & 0x7f);
                 ident2 = ((m->codeword[2]) & 0x1fff);
                 rsvd = ((m->codeword[1]) >>4 & 0x3);  // len
                 sprintf(ptext,"- HEAD | Short data message             | Org:(%d)%d  Tar:(%d)%d  Cwords: %d",prefix,ident2,prefix2,ident1,rsvd);
                 if (verb==1){printbins(m->codeword[0]);printbins(m->codeword[1]);printbins(m->codeword[2]);printbins(m->codeword[3]);}
                 pprint(ptext);
                }

               
                if (cat == 0x0 && type == 0x3 && func == 0x1) {
                channel = ((m->codeword[1] << 8 | m->codeword[2] >> 8) & 0x3ff);
                channel2 = (baseFreq+((channel+offset-2)*step));
                sprintf (ptext,"- MAINT| Call maintenance message       | (Act. Chan: %d Freq: %.4f MHz)", channel, channel2);
                if (verb==1){printbins(m->codeword[0]);printbins(m->codeword[1]);printbins(m->codeword[2]);printbins(m->codeword[3]);}
                pprint(ptext);
                }

    # if VERBOSE
                    printf("(0)");
                    printbins(m->codeword[0]);
                    printf("(1)");
                    printbins(m->codeword[1]);
                    printf("(2)");
                    printbins(m->codeword[2]);
                    printf("(3)");
                    printbins(m->codeword[3]);
#endif          
                if (cat == 0x0 && type == 0x3 && func == 0x3) {
                channel = ((m->codeword[1] << 8 | m->codeword[2] >> 8) & 0x3ff);
                channel2 = (baseFreq+((channel+offset-2)*step));
                
                 if(sound) printf("%c",beep);
                 sprintf (ptext,"- MOVE | Move to specified Control-Chan.|      ->     Ch:%3d Freq:%.4f MHz",channel,channel2);
                 if (verb==1){printbins(m->codeword[0]);printbins(m->codeword[1]);printbins(m->codeword[2]);printbins(m->codeword[3]);}
                 pprint(ptext);
                }

		if (m->codeword[1] & (1<<10)) {
#if 1
		    para = m->codeword[2];
		    para += (m->codeword[1] & 0x03) << 16;

		    /* Endast nedkopplingen */
		    if ((para & 0xaaa) == 0xaaa) {
			time_t t = time(NULL);
			channel = (m->codeword[0]>>5 & 0x2ff);
			channelc = ((m->codeword[0] << 5 | m->codeword[1] >> 11) & 0x3ff);
            channel2 = (baseFreq+((channel+offset-2)*step));

                                        /* Clear Down Allocated Traffic Channel */
                         
			sprintf(ptext,"- CLEAR| Call clear-down                | Ch: %d  Freq: %.4f \n       | CCh: %d\t\t\t| %s", channel, channel2,channelc, ctime(&t));
            if (verb==1){printbins(m->codeword[0]);printbins(m->codeword[1]);printbins(m->codeword[2]);printbins(m->codeword[3]);}			
            pprint(ptext);

                                        /* We back to Control Channel */
                        //printf("[END ");
                        
                        setfreq(control);

#if 0
			printf("CAT: 0x%1.1x ", (m->codeword[1]>>7) & 0x7);
			printf("TYPE: 0x%1.1x ", (m->codeword[1]>>5) & 0x3);
			printf("FUNC: 0x%1.1x ", (m->codeword[1]>>2) & 0x7);
			printf("PARA: 0x%5.5x ", para);
			printf("Chanel: 0x%d", m->codeword[0]>>5 & 0x2ff);
			printf("\n");
#endif
		    }
#endif
		} else {
		    sprintf(ptext,"-  GTC | Go To Channel ");
			if (m->codeword[1] & 0x200) {
                  strcat(ptext,"Data             | ");                                   /* Data Call */
                  } else {
                    strcat(ptext,"Voice            | ");                                   /* Voice Call */
                    //if(sound) printf("%c",beep);
                    if ((prefix & TARGET_PREFIX) == prefix) {
                    if ((ident1 & TARGET_IDENT) == ident1) {   
                         //printf("[");
                            
                            // ende
                         
                     }
                   }
               }	    
            
                    prefix = ((m->codeword[0] & 0x7f00) >> 8);
                    ident1 = ((m->codeword[0] << 5 | m->codeword[1] >> 11) & 0x1fff);
                    ident2 = ((m->codeword[2] >>2) & 0x1fff);
                    sprintf(ptext,"%s(%3d)  Org: %4d       Tar: %4d \n", ptext,prefix, ident2,ident1);
                    
                    channel = ( (m->codeword[1] << 1 | m->codeword[2] >> 15) & 0x3ff);
		            sprintf(ptext,"%s       | Ch:%3d ", ptext, channel);
                    channel2 = (baseFreq+((channel+offset-2)*step));
                    sprintf (ptext,"%s   Freq:%.4f Mhz    |         ", ptext, channel2);
                    if (!(m->codeword[1] & 0x200)) {
                        time_t t = time(NULL);
                        sprintf (ptext,"%s%s", ptext, ctime(&t));
//------------------------------------------------------------------------------------------------                        
                                          
                     if (trg_pre == 9999) {
                                          setfreq(channel2);
                                          if(sound) printf("%c",beep);
                                          }
                     if ((trg_pre == prefix) & (trg_id == 9999)) {
                                          setfreq(channel2);
                                          if(sound) printf("%c",beep);
                                          }
                     if ((trg_pre == prefix) & (trg_id == ident2)) {
                                          setfreq(channel2);
                                          if(sound) printf("%c",beep);
                                          }
                     if (trg_id == ident1) {
                                          setfreq(channel2);
                                          if(sound) printf("%c",beep);
                                          }
//------------------------------------------------------------------------------------------------                        

                        
//                                                setfreq(channel2);
                    }


     



#if  0
                    printf("RAW DATA 0x%x ", m->codeword[0]);
                    printf("%x ", m->codeword[1]);
                    printf("%x ", m->codeword[2]);
                    printf("[%x]", m->codeword[3]);
#endif
                    if (verb==1){printbins(m->codeword[0]);printbins(m->codeword[1]);printbins(m->codeword[2]);printbins(m->codeword[3]);}
                    pprint(ptext);


		}

	    }
	    m->state = 0;
	    m->cnt = 0;
	}
	break;
    default:
	m->state = 0;
    }
}


//-----------------------------------------------------------------------------

double qrg;
void setfreq(double qrg)
{

if (rx == 1) {
                (rxa = 1000000); // Multiplikator
                (rxb = 12);      // CR
                (rxc = 13);      // LF
                (rxd = 14);      // Ende
                (rxe = 2);       // Stoppbit
                (rxf = 14);      // Wortlaenge
                char qrg2[50];
                qrg=qrg * rxa;
                
                sprintf(qrg2,"RF0%f",qrg);
                
                qrg2[rxb]=10;
                qrg2[rxc]=13;
                qrg2[rxd]=0;
                                {
                                    CSerial ar8200; 
                                    ar8200.ModeSet(portspeed,8,NOPARITY,rxe); 
                                    ar8200.Open(portadr,portspeed,8,NOPARITY,rxe);
                                    ar8200.SendData(qrg2,rxf); 
                                    ar8200.Close();
                                }
                            
                }
                
                
if (rx == 2) {
                (rxa = 10000); // Multiplikator
                (rxb = 14);      // CR
                (rxc = 15);      // LF
                (rxd = 16);      // Ende
                (rxe = 2);       // Stoppbit
                (rxf = 16);      // Wortlaenge
                char qrg2[50];
                char qrg3[10];
                char qrg4[10];
                qrg=qrg * rxa;

                sprintf(qrg2,"PM500 0%f",qrg);
                qrg2[rxb]=10;
                qrg2[rxc]=13;
                qrg2[rxd]=0;
                
                sprintf(qrg3,"ARN%f");
                qrg3[3]=10;
                qrg3[4]=13;
                qrg3[5]=0;
                
                sprintf(qrg4,"RM NFM%f");
                qrg4[6]=10;
                qrg4[7]=13;
                qrg4[8]=0;
                

                    {
                        CSerial ar8200; 
                        ar8200.ModeSet(portspeed,8,NOPARITY,rxe); 
                        ar8200.Open(portadr,portspeed,8,NOPARITY,rxe);
                        ar8200.SendData(qrg2,rxf);
                        ar8200.SendData(qrg4,8);
                        ar8200.SendData(qrg3,5);
                        ar8200.SendData(qrg3,5); 
                        ar8200.Close();
                        }
                    
             
                }


}

//-----------------------------------------------------------------------------


