<?php
/*
 *      PHP Frontend for pocsag monitor
 *
 *      Copyright (C) 2004-2005
 *          Manuel Weiser (info@manuelw.de)
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

///////////////////////////////////////////////
// WICHTIG!!!!
//
// INFO, FRAGEN UND SONSTIGES ZUM FRONTEND UNTER 
// http://www.fire-devils.org oder manuelw@fire-devils.org
//
// Damit auch alles in die DB gespeichert wird sollte man
// "index.php?nooutput=1" in einen Cron aller Minute einbinden.
//
// Die Status mssen in der .monrc folgendermaen
// definiert sein. Wichtig ist das KFZ: bzw LST: voran steht.
// STATUS_F_KFZ	0	$KFZ: 0-Notruf
// STATUS_F_KFZ	1	KFZ: 1-einsatzbereit auf Funk
// STATUS_F_KFZ	2	KFZ: 2-einsatzbereit auf Wache
// STATUS_F_KFZ	3	KFZ: 3-Einsatzauftrag bernommen
// STATUS_F_KFZ	4	KFZ: 4-an Einsatzstelle
// STATUS_F_KFZ	5	KFZ: 5-Sprechwunsch
// STATUS_F_KFZ	6	KFZ: 6-nicht einsatzbereit
// STATUS_F_KFZ	7	KFZ: 7-Patient aufgenommen #Rckfahrt,nicht einsatzb.
// STATUS_F_KFZ	8	KFZ: 8-Ankunft mit Patient #Wache ein,nicht einsatzb.
// STATUS_F_KFZ	9	KFZ: 9-verstanden (Handquittung)
// STATUS_F_KFZ	a	KFZ: Standort
// STATUS_F_KFZ	b	$KFZ: B (Kfz)
// STATUS_F_KFZ	c	$KFZ: C (Kfz)
// STATUS_F_KFZ	d	$KFZ: D (Kfz)
// STATUS_F_KFZ	e	KFZ: Fahrzeugquittung
// STATUS_F_KFZ	f	KFZ: Sprechtaste
//
// STATUS_F_LST	0	LST: Statusabfrage
// STATUS_F_LST	1	LST: A-Sammelruf
// STATUS_F_LST	2	LST: E-Einrcken/Abbrechen
// STATUS_F_LST	3	LST: C-fr Einsatzbernahme melden
// STATUS_F_LST	4	LST: F-ber Telefon melden
// STATUS_F_LST	5	LST: H-Wache anfahren
// STATUS_F_LST	6	LST: J-Sprechaufforderung
// STATUS_F_LST	7	LST: L-Lagemeldung durchgeben
// STATUS_F_LST	8	LST: P-Fernwirken
// STATUS_F_LST	9	LST: U-Fernwirken II
// STATUS_F_LST	a	LST: Textbertragung
// STATUS_F_LST	b	LST: Zielort durchgeben
// STATUS_F_LST	c	LST: C (Lst)
// STATUS_F_LST	d	LST: D (Lst)
// STATUS_F_LST	e	LST: Bereitschaftsanfrage
// STATUS_F_LST	f	LST: automatische Quittung
////////////////////////////////////////////////////////////

setlocale(LC_TIME, 'de_DE');
// Webseiten konfig
$pagetitle = 'pocsag - ZVEI - FMS - Monitor';
$meta = '
<META http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<META NAME="author" CONTENT="Monitor - Manuel Weiser">
<META NAME="publisher" CONTENT="Monitor - Manuel Weiser">
<META NAME="copyright" CONTENT="Monitor - Manuel Weiser">
<META NAME="description" CONTENT="Monitor">
';
$css = '<link href="/monitor.css" rel="stylesheet" type="text/css">';

// URL deines Webinterface
$monitordomain = "http://localhost";

// Login Info Text
$login_infotext = '<center><h3><b>Nicht vergessen, auch mal ins Forum schauen !!!</b></h3><a href="http://www.fire-devils.org" target="_blank">ZUM FORUM</a></center>';

// Templates / Sprachen (nicht ndern)
$template_dir 	= '_html/';

// Updatefunktion fr bestehenden Eintrge der monrc
// Sollen Namen und Text aus der monrc fr KFZ zB.
// bernommen werden
$update_adresse_monrc = 1;

// IP Bereich fr auto Login
$ip_start   = '192.168.2.5';
$ip_ende    = '192.168.2.50';

// Status Farben
$status_bg          = '#FFECB3';
$status_size        = '11';
$status_color[1]    = 'green';
$status_format[1]   = 'bold';
$status_color[2]    = 'orange';
$status_format[2]   = 'bold';
$status_color[3]    = 'red';
$status_format[3]   = 'bold';
$status_color[4]    = '#CC0099';
$status_format[4]   = 'bold';
$status_color[5]    = 'gray';
$status_format[5]   = 'normal';
$status_color[6]    = 'blue';
$status_format[6]   = 'normal';
$status_color[7]    = 'blue'; //'#FF6666';
$status_format[7]   = 'bold';
$status_color[8]    = '#6699CC';
$status_format[8]   = 'bold';
$status_color[9]    = 'red'; //'black';
$status_format[9]   = 'normal';
$status_color[15]   = 'gray';
$status_format[15]  = 'normal';

// Status korrektur
$korr_kenner        = 1; //Status lschen wenn Fahrzeugkenner keine Ziffern sind (zb 02F3)
$korr_status        = 1; //Korrektur ein = 1 aus = 0

// Alle LST Ausgaben anzeigen (aut.Q)
$aq              	= 0; // 1 anzeigen, 0 filtern

// Zeit die zwischen dem letzen Status und dem zu berichtigendem sein muss,
// das also nich 3aut.Q hintereinandern, welche sicher 1 Status bedeuten sollen
// in 3 fortlaufende Status gendert werden
$korr_status_zeit   = 2; //in min

// Grunddaten fr die Datenbankverbindung
$dbhost = "localhost";
$dbuser = "root";
$dbpass = "";
$dbname = "test";

// Status definieren
$status_kfz[0]  =   'KFZ: 0-Notruf';
$status_kfz[1]  =   'KFZ: 1-einsatzbereit auf Funk';
$status_kfz[2]  =   'KFZ: 2-einsatzbereit auf Wache';
$status_kfz[3]  =   'KFZ: 3-Einsatzauftrag bernommen';
$status_kfz[4]  =   'KFZ: 4-an Einsatzstelle';
$status_kfz[5]  =   'KFZ: 5-Sprechwunsch';
$status_kfz[6]  =   'KFZ: 6-nicht einsatzbereit';
$status_kfz[7]  =   'KFZ: 7-Patient aufgenommen';
$status_kfz[8]  =   'KFZ: 8-Ankunft mit Patient';
//$status_kfz[9]  =   'KFZ: 9-verstanden (Handquittung)';
//$status_kfz[9]  =   'KFZ: 9-Quittung, Anmeldung in fremden SprFuVerKr';
$status_kfz[9]  =   'KFZ: 9-Notarzt aufgenommen';
$status_kfz[15] =   'KFZ: Sprechtaste';

// Organisation
$bos_org = array(
    0   =>  '---',
    1   =>  'POL',
    2   =>  'BGS',
    3   =>  'BKA',
    4   =>  'KATS',
    5   =>  'Zoll',
    6   =>  'FW',
    7   =>  'THW',
    8   =>  'ASB',
    9   =>  'DRK',
    'A' =>  'JUH',
    'B' =>  'MHD',
    'C' =>  'DLRG',
    'D' =>  'RD',
    'E' =>  'ZS',
    'F' =>  'FERN'
);

// Bundesland
$bos_bdl = array(
    0   =>  'Sac',
    1   =>  'Bun',
    2   =>  'BW',
    3   =>  'By1',
    4   =>  'Ber',
    5   =>  'HB',
    6   =>  'HH',
    7   =>  'Hes',
    8   =>  'NS',
    9   =>  'NRW',
    'A' =>  'RPf',
    'B' =>  'SH',
    'C' =>  'SL',
    'D' =>  'By2',
    'E' =>  'MV/SA',
    'F' =>  'Bra/Th'
);

// Ort
$bos_ort = array(
#Sachsen
	"014" =>  'Sac Z',    #Zwickau
	"015" =>  'Sac C',    #Chemnitz
	"016" =>  'Sac PL',   #Plauen
	"017" =>  'Sac Z',    #Zwickau
	"018" =>  'Sac ANA',  #Annaberg
	"019" =>  'Sac ASZ',  #Aue-Schwarzenberg
	"020" =>  'Sac Lfs',  #Landesfeuerwehrschule Nardt
	"021" =>  'Sac V',    #Vogtlandkreis
	"022" =>  'Sac FBG',  #Freiberg (Brand-Erbisdorf)
	"023" =>  'Sac STL',  #Chemnitzer Land (Stollberg)
	"024" =>  'Sac FBG',  #Freiberg (Flha)
	"025" =>  'Sac FBG',  #Freiberg
	"026" =>  'Sac GC',   #Chemnitzer Land (Glauchau)
	"027" =>  'Sac MIW',  #Mittweida (Hainichen)
	"028" =>  'Sac HOT',  #Chemnitzer Land (Hohenstein-E.)
	"029" =>  'Sac V',    #Vogtlandkreis (Klingenthal)
	"031" =>  'Sac MEK',  #Mittlerer Erzgebirgskreis (Marienbg.)
	"032" =>	'Sac V',	#Vogtlandkreis (Oelsnitz)
	"033" =>	'Sac V',	#Vogtlandkreis (Plauen)
	"034" =>	'Sac MIW',	#Mittweida (Rochlitz)
	"035" =>	'Sac ASZ',	#Aue-Schwarzenberg
	"037" =>	'Sac WDA',	#Zwickauer Land (Werdau)
	"038" =>	'Sac MEK',	#Mittlerer Erzgebirgskreis (Tschopau)
	"039" =>	'Sac Z',	#Zwickauer Land (Zwickau)
	"040" =>	'Sac RPC',	#Regierungsprsidium Chemnitz
	"041" =>	'Sac V',	#Vogtlandkreis (Reichenbach)
	"042" =>	'Sac Z',	#Zwickauer Land (Zwickau)
	"043" =>	'Sac Z',	#Zwickauer Land (Zwickau)
	"044" =>	'Sac C',	#Chemnitzer Land (Chemnitz)
	"051" =>	'Sac DD',	#Dresden
	"052" =>	'Sac GR',	#Grlitz
	"053" =>	'Sac BZ',	#Bautzen
	"054" =>	'Sac BZ',	#Bautzen-Land
	"055" =>	'Sac BIW',	#Bautzen-Land (Bischofswerda)
	"056" =>	'Sac DPW',	#Weieritzkreis (Dippoldiswalde)
	"057" =>	'Sac MEI',	#Meien-Radebeul
	"058" =>	'Sac FTL',	#Weieritzkreis (Freital)
	"059" =>	'Sac NOK',	#Niederschlesischer Oberlausitzkreis
	"060" =>	'Sac RPD',	#Regierungsprsidium Dresden
	"061" =>	'Sac RG',	#Riesa-Groenhain (Groenhain)
	"062" =>	'Sac KM',	#Kamenz
	"063" =>	'Sac KM',	#Kamenz
	"064" =>	'Sac LB',	#Lbau-Zittau (Lbau)
	"065" =>	'Sac MEI',	#Meien-Radebeul (Radebeul)
	"066" =>	'Sac NOK',	#Niederschlesischer Oberlausitzkreis
	"067" =>	'Sac PIR',	#Schsische Schweiz (Pirna)
	"068" =>	'Sac RG',	#Riesa-Groenhain (Riesa)
	"069" =>	'Sac SEB',	#Schsische Schweiz (Sebnitz)
	"071" =>	'Sac NOK',	#Niederschlesischer Oberlausitzkreis
	"072" =>	'Sac ZI',	#Lbau-Zittau (Zittau)
	"073" =>	'Sac HY',	#Hoyerswerda
	"080" =>	'Sac RPL',	#Regierungsprsidium Leipzig
	"081" =>	'Sac L',	#Leipzig
	"082" =>	'Sac L-B',	#Leipziger Land (Borna)
	"083" =>	'Sac DZ',	#Delitzsch
	"084" =>	'Sac DBL',	#Dbeln
	"085" =>	'Sac EIL',	#Delitzsch (Eilenburg)
	"086" =>	'Sac GHA',	#Leipziger Land (Geithain)
	"087" =>	'Sac GRM',	#Muldentalkreis (Grimma)
	"088" =>	'Sac L-L',	#Leipziger Land (Leipzig)
	"089" =>	'Sac ToO',	#Torgau-Oschatz (Oschatz)
	"091" =>	'Sac ToT',	#Torgau-Oschatz (Torgau)
	"092" =>	'Sac WUR'	#Muldentalkreis (Wurzen)
);

// Farben fr Organisationen
$orgcolor["4"]    = 'purple'; // Kats
$orgcolor["6"]    = 'red';    // FW
$orgcolor["7"]    = 'blue';   // THW
$orgcolor["8"]    = 'green';  // RD ASB
$orgcolor["9"]    = 'green';  // RD DRK
$orgcolor["A"]    = 'green';  // RD JUH
$orgcolor["B"]    = 'green';  // RD MHD
$orgcolor["C"]    = 'green';  // RD DLRG
$orgcolor["D"]    = 'green';  // RD sonstige

//
// Datenbankserververbindung aufbauen und Datenbank auswhlen
//
$dbconn = mysql_connect($dbhost, $dbuser, $dbpass) or die (mysql_error());
$dbselect = mysql_select_db($dbname, $dbconn) or die (mysql_error());

//
// Sessions starten
//
session_start();

/////////////////
// Requires
/////////////////
require('functions.inc.php');

//////////////
// Requires
//////////////	
//require('javascript.inc.php');
//require('vote.inc.php');
require('loginfunctions.inc.php');

// Navigationsleiste
$nav_menu	=  '<a href="index.php">Home</a>&nbsp;|&nbsp;';
$nav_menu	.= '<a href="suche.php">Suche</a>&nbsp;|&nbsp;';
$nav_menu	.= '<a href="kfz.php">Fahrzeuge</a>&nbsp;|&nbsp;';
$nav_menu	.= '<a href="profile.php">Profil</a>&nbsp;|&nbsp;';
$nav_menu	.= '<a href="stats.php">Stats</a>&nbsp;|&nbsp;';
$nav_menu   .= '<a href="http://board.fire-devils.org" target="_blank"><b>FORUM</b></a>&nbsp;|&nbsp;';

$nav_menu	.= '<script type="text/javascript" src="overlibmws.js"></script><div id="overDiv" style="position:absolute; visibility:hidden; z-index:1000"></div>';
?>
