<?php

/*
 *      PHP Frontend for pocsag monitor
 *
 *      Copyright (C) 2004-2005
 *          Manuel Weiser (info@manuelw.de)
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

// Status prfen, berichtigen, ersetzen
function repair_status($kennung, $zeit_neu, $status_alt, $zeit_alt) {
	global $korr_status_zeit, $status_kfz;

	$spanne = mktime(substr($zeit_neu,8,2), substr($zeit_neu,10,2), substr($zeit_neu,12,2), substr($zeit_neu,4,2), substr($zeit_neu,6,2), substr($zeit_neu,0,4)) - mktime(substr($zeit_alt,8,2), substr($zeit_alt,10,2), 0, substr($zeit_alt,4,2), substr($zeit_alt,6,2), substr($zeit_alt,0,4));
	$spanne = (int)($spanne / 60);
	
    if( $spanne > $korr_status_zeit )
    {
		// Wenn FW
		if( substr($kennung,0,1) == '6' )
		{
			if( $status_alt == '1' ) $neu["status"] = '2';
			if( $status_alt == '2' ) $neu["status"] = '3';
			if( $status_alt == '3' ) $neu["status"] = '4';
			if( $status_alt == '4' ) $neu["status"] = '1';
			if( $status_alt == '6' ) $neu["status"] = '2';
			if( $status_alt == '9' ) $neu["status"] = '1';
		}
		else
		{
			if( $status_alt == '1' ) $neu["status"] = '2';
		    if( $status_alt == '2' ) $neu["status"] = '3';
			if( $status_alt == '3' ) $neu["status"] = '4';
			//if( $status_alt == '4' ) $neu["status"] = '1';
			if( $status_alt == '4' ) $neu["status"] = '7';
			if( $status_alt == '6' ) $neu["status"] = '2';
			if( $status_alt == '7' ) $neu["status"] = '8';
			if( $status_alt == '8' ) $neu["status"] = '1';
			if( $status_alt == '9' ) $neu["status"] = '1';
		}

		$neu["text"]    = $status_kfz[$neu["status"]].' (R)';
		$neu["db"] = 1;
		
    }
    else
    {
        $neu["status"] = '15';
		$neu["text"] = 'LST: automatische Quittung (R)';
        $neu["db"] = 0;
        //$show_stats = 0;
    }
    
    return $neu;
}

// Datum lang auslesen
function get_date_long($time) {
	$jahr	= substr($time,0,4);
	$monat	= substr($time,4,2);
	$tag	= substr($time,6,2);
	
	$time	= strftime("%A, %d.%m.%Y", mktime(0,0,0, $monat,$tag,$jahr));
	
	return $time;
}

// Stunde:Minute:Sekunde aus Timestamp lesen
function get_time($time) {
	$h	= substr($time,-6,2);
	$m	= substr($time,-4,2);
	$s	= substr($time,12,2);
		
	$time 	= $h.':'.$m.':'.$s;
	return $time;
}

function get_timestamp($time) {
	$jahr	= substr($time,0,4);
	$monat	= substr($time,4,2);
	$tag	= substr($time,6,2);
	$h	= substr($time,-6,2);
	$m	= substr($time,-4,2);
	$s	= substr($time,12,2);
	
	$time = mktime($h, $m, $s, $monat, $tag, $jahr);
	
	return $time;
}

// Tag auslesen
function get_day($time) {
	$day	= substr($time,6,2);
	
	return $day;
}

// Filter Zeit errechnen
function filter_zeit($filter) {
	$filter = date("YmdHis", mktime(date("G")-$filter,date("i"),date("s"), date("m"),date("d"),date("Y")));
	
	return $filter;
}

function get_org($kennung) {
	global $bos_org, $bos_ort;

	$org	= substr($kennung,0,1);
	$ort	= substr($kennung,1,3);
	
	$bos    = $bos_org[$org].' '.$bos_ort[$ort]; //.' <font color="black"> | </font>';
	
	return $bos;

	//return $bos_org[$org].' '.$bos_ort[$ort].' <font color="black"> | </font>';
}

function search_time_small($time) {
	list($stunde, $minute) = explode(":", $time);
	$time = $stunde.$minute;
	
		return $time;
}

function ip2str($ip) {
    $ip = preg_replace("/(\d{1,3})\.?/e", 'sprintf("%03d", \1)', $ip);

    return (string)$ip;
}

####################################################
#function get_day($feld) {
#	if ($feld == 1) return 'Montag';
#	if ($feld == 2) return 'Dienstag';
#	if ($feld == 3) return 'Mittwoch';
#	if ($feld == 4) return 'Donnerstag';
#	if ($feld == 5) return 'Freitag';
#	if ($feld == 6) return 'Samstag';
#	if ($feld == 7) return 'Sonntag';
#}

function check_url ($url) {
	if (!$url)
	{
		$url = 'http://';
	}
	else 
	{
		list($http, $www) = explode(":", $url);
			if ($http != 'http') $url = 'http://'.$url;
	}
	
	return $url;
}

function span2min($from,$to) {
	list($f_stunde, $f_minute, $f_sek) = explode(":", $from);
	list($t_stunde, $t_minute, $t_sek) = explode(":", $to);
	
		$stunden = ($t_stunde - $f_stunde) * 60;
		$minuten = ($f_minute - $t_minute);
		$span	 = ($stunden - $minuten);
		
		return $span;
}

function span2hour($from,$to) {
	list($f_stunde, $f_minute, $f_sek) = explode(":", $from);
	list($t_stunde, $t_minute, $t_sek) = explode(":", $to);
	
		//if ($t_stunde == '00') $t_stunde = '24';
		if ($t_stunde < $f_stunde) $t_stunde = (24 + $t_stunde);
	
		if ($t_minute >= $f_minute)
		{
			$stunden = ($t_stunde - $f_stunde);
			$minuten = ($t_minute - $f_minute);
		}
		else
		{
			$stunden = ($t_stunde - $f_stunde) -1;
			$minuten = 60 - ($f_minute - $t_minute);
		}
		
			if ($stunden != 1) { $h_text = ' Stunden '; } else { $h_text = ' Stunde '; }
			if ($minuten != 1) { $m_text = ' Minuten '; } else { $m_text = ' Minute '; }
			
		return ('<b>'.$stunden.'</b>'.$h_text.'<b>'.$minuten.'</b>'.$m_text);
}

function span2hour_short($from,$to) {
	list($f_stunde, $f_minute, $f_sek) = explode(":", $from);
	list($t_stunde, $t_minute, $t_sek) = explode(":", $to);
	
		//if ($t_stunde == '00') $t_stunde = '24';
		if ($t_stunde < $f_stunde) $t_stunde = (24 + $t_stunde);
	
		if ($t_minute >= $f_minute)
		{
			$stunden = ($t_stunde - $f_stunde);
			$minuten = ($t_minute - $f_minute);
		}
		else
		{
			$stunden = ($t_stunde - $f_stunde) -1;
			$minuten = 60 - ($f_minute - $t_minute);
		}
		
			if ($stunden != 1) { $h_text = ' Stunden '; } else { $h_text = ' Stunde '; }
			if ($minuten != 1) { $m_text = ' Minuten '; } else { $m_text = ' Minute '; }
			
		return ($stunden.':'.$minuten);
}

function add_span2db ($span,$dbspan) {
	list($new_stunden, $new_minuten) = explode(":", $span);
	list($old_stunden, $old_minuten) = explode(":", $dbspan);
	
		$stunden = ($new_stunden + $old_stunden);
		$minuten = ($new_minuten + $old_minuten);
		
		if ($minuten > 60)
		{
			$minuten = $minuten - 60;
			$stunden = $stunden + 1;
		}
		
		return (doublenum($stunden).':'.doublenum($minuten));
}

function del_span2db ($span,$dbspan) {
	list($del_stunden, $del_minuten) = explode(":", $span);
	list($old_stunden, $old_minuten) = explode(":", $dbspan);
	
		$stunden = ($old_stunden - $del_stunden);
		$minuten = ($old_minuten - $del_minuten);
		
		if ($minuten < 0)
		{
			$minuten = 60 + $minuten;
			$stunden = $stunden - 1;
		}
		
		return (doublenum($stunden).':'.doublenum($minuten));
}

function split_time($split) {
	list($stunde, $minute) = explode(":", $split);

			if ($stunde != 1) { $h_text = ' Stunden '; } else { $h_text = ' Stunde '; }
			if ($minute != 1) { $m_text = ' Minuten '; } else { $m_text = ' Minute '; }
	
		return ('<b>'.$stunde.'</b>'.$h_text.'<b>'.$minute.'</b>'.$m_text);
}

function split_year($split) {
	list($jahr, $monat, $tag) = explode("-", $split);
	
	return $jahr;
}

function split_month($split) {
	list($jahr, $monat, $tag) = explode("-", $split);
	
	return $monat;
}

function split_day($split) {
	list($jahr, $monat, $tag) = explode("-", $split);
	
	return $tag;
}

function split_kfz($kfz) {
	$kfz = explode(",", $kfz);

	return $kfz;
}

function count_total($tocount) {
	$result = mysql_query("SELECT Count(*) as $tocount FROM $tocount");
	$result = mysql_fetch_array($result);
	return $result[$tocount];
}

function minimize($num) {
	$wert = 40 * $num / 100;
	$wert = $num - $wert;
	return $wert;
}

function doublenum($num) {
	if($num < 10) $num = '0'.$num;
	return $num;	
}

function gettemplate($template,$endung="html") {
	return str_replace("\"","\\\"",implode("",file($template.".".$endung)));
}

function dooutput($template) {
	echo $template;
}

function banner_typ($typ) {
  list($bild, $typ) = explode(".", $typ);
  return $typ;
}

function date_format($setdate) {
  list($jahr, $monat, $tag) = explode("-", $setdate);
  return sprintf("%02d.%02d.%04d", $tag, $monat, $jahr);
}

function date_long_format($setdate) {
  list($jahr, $monat, $tag) = explode("-", $setdate);
  //return sprintf("%02d.%02d.%04d", $tag, $monat, $jahr);
  return strftime("%A, %d. %B %Y", mktime(0,0,0, date($monat),date($tag),date($jahr)));
}


function date_dbformat($setdate) {
  list($tag, $monat, $jahr) = explode(".", $setdate);
  return sprintf("%04d-%02d-%02d", $jahr, $monat, $tag);
}

function time_format($settime) {
  list($stunde, $minute, $sek) = explode(":", $settime);
  return sprintf("%02d:%02d", $stunde, $minute);
}

function udirsize($dir) {
    $dh = opendir($dir);
    $size = 0;
    while (($file = readdir($dh)) !== false)
        if ($file != "." and $file != "..") {
            $path = $dir."/".$file;
            if (is_dir($path))
                $size += udirsize($path);
            elseif (is_file($path))
                $size += filesize($path);
        }
    closedir($dh);
    $Space = $size/1024/1024;
    $Space = round($Space,2);

	return $size;
}

function dirsize($dir) {
    $dh = opendir($dir);
    $size = 0;
    while (($file = readdir($dh)) !== false)
        if ($file != "." and $file != "..") {
            $path = $dir."/".$file;
            if (is_dir($path))
                $size += udirsize($path);
            elseif (is_file($path))
                $size += filesize($path);
        }
    closedir($dh);
    $Space = $size/1024/1024;
    $Space = round($Space,2);

	return $Space.' MB';
}

    function compile_db_string($data) {
    
    	$field_names  = "";
		$field_values = "";
		
		foreach ($data as $k => $v) {
			$v = preg_replace( "/'/", "\\'", $v );
			$field_names  .= "$k,";
			$field_values .= "'$v',";
		}
		
		$field_names  = preg_replace( "/,$/" , "" , $field_names  );
		$field_values = preg_replace( "/,$/" , "" , $field_values );
		
		return array( 'FIELD_NAMES'  => $field_names,
			      'FIELD_VALUES' => $field_values,
			    );
	}
	
	function pass_erstellen ($wert) {
		 $i = 0;
		 while($i < $wert) {
		  mt_srand((double)microtime()*1000000);
		  $zahl = mt_rand(1,20);
		  if ($zahl == 4) {
		   $zahl = mt_rand(0,9);
		   $pass = $pass.$zahl;
		  } else {
		   $zahl = mt_rand(97,122);
		   $zufall = mt_rand(1,2);
		   if ($zufall == 2) {
		    $pass = $pass.strtoupper(chr($zahl));   
		   } else {
		    $pass = $pass.chr($zahl);
		   }
		  }
		  $i++; 
		 }
		 return $pass;
	}

function no_access($text) {
	return '<br>
        <table width="300" border="0" align="center" cellpadding="0" cellspacing="1" bgcolor="#000000">
          <tr background="images/box_back.gif">
	        <td colspan="2" background="images/box_back.gif">
			  	<font color="#FF0000" size="2" face="Verdana, Arial, Helvetica, sans-serif"><strong>&nbsp;No Access</strong></font>
			</td>
          </tr>
          <tr bgcolor="#FFFFFF">
            <td class="text_normal">
				<br><div align="center">'.$text.'</div><br>
			</td>
          </tr>
          <tr>
            <td height="30" bgcolor="#FFFFFF">
				<div align="center"><a href="javascript:history.back()">zurck</a></div>
			</td>
          </tr>
        </table>';
}

function gohome($goto) {
  $refresh = '<meta http-equiv="refresh" content="1;URL='.$goto.'">';
  return $refresh;
}

function mail_pass($email,$pass) {
			$body = ("--------------------------------------------------------\n"
				."Login zur Pocsag Seite\n"
				."--------------------------------------------------------\n\n"
				."ber folgenden Link kannst du die Pocsag Seite besuchen: \n"
                ."http://monitor.manuelw.no-ip.com?login=$pass \n\n"
                ."ACHTUNG: Der Login ist nur einmal gltig! \n\n"
				."--------------------------------------------------------\n"
				."Dies ist eine automatische EMail auf eine Loginanfrage. \n\n"
				."--------------------------------------------------------");
			mail("$email", "Monitor Loginanfrage", $body, "From: monitor");
}

function mail_alarm($datum,$zeit,$email,$org,$org_name,$bezeichnung,$text) {
			$body = ("--------------------------------------------------------\n"
				."Alarmauslsung fr $org $org_name \n"
				."--------------------------------------------------------\n\n"
				."Datum: $datum, $zeit \n"
				."Bezeichnung: $bezeichnung \n\n"
   				."Info: $text \n\n"
				."--------------------------------------------------------\n"
				."Dies ist eine automatische Info-EMail. \n"
				."--------------------------------------------------------");
			mail("$email", "Monitor Alarm: $org $org_name", $body, "From: monitor");
}

function mail_alarm_sms($datum,$zeit,$email,$org,$org_name,$text) {
			$body = ("$datum, $zeit");
			mail("$email", "$org $org_name: $text", $body, "From: monitor");
}

$timestampnow		= date("YmdHis");
$timestamp_date_now	= date("Ymd");
$datnow 		= date("Y-m-d", mktime(0,0,0, date("m"),date("d"),date("Y")));
$dat2month 		= date("Y-m-d", mktime(0,0,0, date("m")-2,date("d"),date("Y")));
$dat3month 		= date("Y-m-d", mktime(0,0,0, date("m")-3,date("d"),date("Y")));
$datshownow		= date_format(date("Y-m-d", mktime(0,0,0, date("m"),date("d"),date("Y"))));
$datlargenow 		= strftime("%A, %d.%m.%Y", mktime(0,0,0, date("m"),date("d"),date("Y")));
$yearnow 		= date("Y", mktime(0,0,0, date("m"),date("d"),date("Y")));
$monthnow		= date("m", mktime(0,0,0, date("m"),date("d"),date("Y")));
$timenow 		= date("G:i");
?>
