#!/usr/bin/php
<?php
require_once('PDU.encode.php'); // Unterfunktionen zum Encodieren von SDS-PDUs
#require_once('PDU.decode.php'); // debug

#/usr/local/sds2db/bin/SDSencode.php --ProtoIdent 10 --PduType 0 --TimeElapsed 0 --PosErr 7 --HorVeloc 127 --DirOfTravel 15 --TypeOfAddData 0 --ReasonForSending 20 --Longitude 13.000000 --Latitude 52.000000

#/usr/local/sds2db/bin/SDSencode.php --ProtoIdent 130 --MsgType 0 --DelivRepReq 0 --ShrtFmRep 0 --StorFwd 0 --MsgRef 255 --TimStmpUsd 0 --TxtCodSch 1 --Text "Hallo Welt, !"

$longopts  = array(
    "ProtoIdent:",		// Required value
    "PduType:",    		// LIP -> PDU type 2 Bit [0-3]
    "TimeElapsed:",		// LIP -> Time elapsed 2 Bit [0-3]
    "Longitude:",		// LIP -> Longitude 25 Bit
    "Latitude:",		// LIP -> Latidude 24 Bit
    "PosErr:",			// LIP -> Position error 3 Bit [0-7]
    "HorVeloc:",		// LIP -> Horizontal velocity 7 Bit [0-127]
    "DirOfTravel:",		// LIP -> Direction of travel 4 Bit [0-15]
    "TypeOfAddData:",		// LIP -> Type of additional data 1 Bit [0-1]
    "ReasonForSending:",	// LIP -> Reason for sending 8 Bit [0-255]
    "MsgType:",			// TXT -> Message type 4 Bit [0-15]
    "DelivRepReq:",		// TXT -> Delivery report request 2 Bit [0-3]
    "ShrtFmRep:",		// TXT -> short form report 1 Bit [0-1]
    "StorFwd:",			// TXT -> Storage/forward control 1 Bit [0-1]
    "MsgRef:",			// TXT -> Message reference 8 Bit [0-255]
    "TimStmpUsd:",		// TXT -> Timestamp used 1 Bit [0-1]
    "TxtCodSch:",		// TXT -> Text coding scheme 7 Bit [0-127]
    "Text:",			// TXT -> User data - Bit Length variable
);
$PDUelements=array();
foreach(getopt("", $longopts) as $key => $value) $PDUelements[$key] = $value;
echo PDU_encode($PDUelements);
#echo print_r(decode_PDU(PDU_encode($PDUelements)))."\n";
?>
