/*
 * Decompiled with CFR 0.152.
 */
package smstrade;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.ImageIcon;
import org.slf4j.LoggerFactory;
import server.AbstractPlugin;
import server.AlarmData;
import server.feedback.FeedbackUtils;
import server.guielements.Checkbox;
import server.guielements.Dropdown;
import server.guielements.GUIElement;
import server.guielements.Label;
import server.guielements.PersonSelectBox;
import server.guielements.Spacer;
import server.guielements.Text;

public class SMSTrade
extends AbstractPlugin {
    private static final long serialVersionUID = 1L;
    private String empfaenger;

    public SMSTrade() {
        this.pluginData.put("description", new Label("Mit diesem Plugin k\u00f6nnen Sie SMS \u00fcber die SMSTrade- Plattform verschicken.", "", 0));
        this.pluginData.put("label", new Label("Logindaten", "\u00dcberschrift", 1));
        this.pluginData.put("login", new Text("Login", "Die Login-Kennung zu Ihrem SMSTrade-Konto", 2));
        this.pluginData.put("absender", new Text("Absender", "Die Absenderkennung der SMS", 3));
        this.pluginData.put("useVerteiler", new Checkbox("Verteiler verwenden", "Ob ein Mail-Verteiler verwendet werden soll", 4));
        this.pluginData.put("verteiler", new Text("Verteiler", "Eine optionale Verteiler-Liste", 5));
        this.pluginData.put("spacer1", new Spacer(3));
        ArrayList<String> gateways = new ArrayList<String>();
        gateways.add("Basic");
        gateways.add("Economy");
        gateways.add("Gold");
        gateways.add("Direct");
        this.pluginData.put("gateway", new Dropdown("Gateway", "Das SMS-Gateway", gateways, 6));
        this.pluginData.put("useTyp", new Checkbox("Speziellen Typ verwenden", "Ob ein spezieller Nachrichtentyp verwendet werden soll (Auswahl siehe unten)", 7));
        ArrayList<String> typ = new ArrayList<String>();
        typ.add("Flash");
        typ.add("Unicode");
        typ.add("Binary");
        typ.add("Voice");
        this.pluginData.put("typ", new Dropdown("Nachrichtentyp", "Ein optionaler Nachrichtentyp", typ, 8));
        this.pluginData.put("debug", new Checkbox("Test (Debug)", "Keine SMS wird versendet, sondern lediglich getestet ob die Einstellungen funktionieren", 9));
        this.pluginData.put("concat", new Checkbox("Alarmtext k\u00fcrzen", "Soll die SMS nach 160 Zeichen gek\u00fcrzt werden", 10));
        this.pluginData.put("person-mobilephone", new PersonSelectBox("Personen", "Handy-Nummern", 11, "mobil"));
        this.retrys = 0;
    }

    public String createURL(String text) {
        StringBuffer buf = (Boolean)((GUIElement)this.pluginData.get("useVerteiler")).getValue() != false ? new StringBuffer("http://gateway.smstrade.de/fms/?") : new StringBuffer("http://gateway.smstrade.de/?");
        buf.append("key=" + this.urlEncoding((String)((GUIElement)this.pluginData.get("login")).getValue()));
        if (((Boolean)((GUIElement)this.pluginData.get("useVerteiler")).getValue()).booleanValue()) {
            buf.append("&verteiler=" + this.empfaenger);
        } else {
            buf.append("&to=" + this.empfaenger);
        }
        buf.append("&message=" + this.urlEncoding(text));
        buf.append("&route=" + ((String)((GUIElement)this.pluginData.get("gateway")).getValue()).toLowerCase());
        buf.append("&from=" + this.urlEncoding((String)((GUIElement)this.pluginData.get("absender")).getValue()));
        if (((Boolean)((GUIElement)this.pluginData.get("useTyp")).getValue()).booleanValue()) {
            buf.append("&messagetype=" + ((String)((GUIElement)this.pluginData.get("typ")).getValue()).toLowerCase());
        }
        if (text.length() > 160) {
            buf.append("&concat=1");
        }
        buf.append("&message_id=1");
        buf.append("&cost=1");
        if (this.pluginData.get("debug") != null && ((Boolean)((GUIElement)this.pluginData.get("debug")).getValue()).booleanValue()) {
            buf.append("&debug=1");
        }
        return buf.toString();
    }

    private boolean callURL(String url, AlarmData ad) {
        String returnValue;
        block7: {
            String resp;
            URL ur = new URL(url);
            this.logger.debug("URL: " + ur.toString());
            HttpURLConnection con = (HttpURLConnection)ur.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            ArrayList<String> responseCodes = new ArrayList<String>();
            while ((resp = in.readLine()) != null) {
                this.logger.debug(">>> " + resp);
                responseCodes.add(resp);
            }
            in.close();
            returnValue = this.codes((String)responseCodes.get(0), (Boolean)((GUIElement)this.pluginData.get("useVerteiler")).getValue());
            if (returnValue.indexOf("SMS wurde erfolgreich verschickt") == -1) break block7;
            this.logger.info(String.valueOf(this.empfaenger) + " - Status: " + returnValue);
            if (responseCodes.size() >= 2) {
                this.logger.info(String.valueOf(this.empfaenger) + " - MessageID: " + (String)responseCodes.get(1));
            }
            if (responseCodes.size() >= 3) {
                this.logger.info(String.valueOf(this.empfaenger) + " - Verursachte Kosten: " + (String)responseCodes.get(2));
            }
            return true;
        }
        try {
            ad.addPluginError(this.toString(), returnValue);
            this.logger.error(String.valueOf(this.empfaenger) + ": " + returnValue);
            return false;
        }
        catch (MalformedURLException e) {
            this.logger.error("URL konnte nicht generiert werden", (Throwable)e);
            ad.addPluginError(this.toString(), e.getMessage());
            return false;
        }
        catch (Exception e) {
            this.logger.error("URL konnte nicht ge\u00f6ffnet werden", (Throwable)e);
            ad.addPluginError(this.toString(), e.getMessage());
            return false;
        }
    }

    private static void createDisableSslVerification(HttpsURLConnection con) {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            con.setSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            con.setHostnameVerifier(allHostsValid);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }

    private String urlEncoding(String toEncode) {
        try {
            toEncode = toEncode.trim();
            return URLEncoder.encode(toEncode, "ISO-8859-1").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("Fehler beim Codieren der Nachricht", (Throwable)e);
            return toEncode;
        }
    }

    private String codes(String urlValue, boolean isVerteiler) {
        String returnText = "Unbekannter Fehler";
        if (isVerteiler) {
            returnText = returnText.toLowerCase().indexOf("error") != -1 ? "SMS konnte nicht korrekt an Verteilerliste \u00fcbergeben werden (" + urlValue + ")" : "SMS wurde erfolgreich verschickt (Anzahl: " + urlValue + ")";
        } else {
            if (urlValue.indexOf("100") != -1) {
                return "SMS wurde erfolgreich verschickt";
            }
            returnText = urlValue.indexOf("10") != -1 ? "Empf\u00e4ngernummer nicht korrekt - Korrektes Format verwenden, z.B. 491701231231" : (urlValue.indexOf("20") != -1 ? "Absenderkennung nicht korrekt. - Absender mit maximal 11 alpha-numerischen Zeichen oder 16 numerischen Zeichen verwenden" : (urlValue.indexOf("30") != -1 ? "Nachrichtentext nicht korrekt" : (urlValue.indexOf("31") != -1 ? "Messagetyp nicht korrekt" : (urlValue.indexOf("40") != -1 ? "SMS Route nicht korrekt" : (urlValue.indexOf("50") != -1 ? "Identifikation fehlgeschlagen - Gateway Key \u00fcberpr\u00fcfen" : (urlValue.indexOf("60") != -1 ? "Nicht gen\u00fcgend Guthaben" : (urlValue.indexOf("70") != -1 ? "Netz wird nicht abgedeckt - Andere Route w\u00e4hlen" : (urlValue.indexOf("71") != -1 ? "Feature nicht m\u00f6glich - Andere Route w\u00e4hlen" : (urlValue.indexOf("80") != -1 ? "\u00dcbergabe an SMS-C fehlgeschlagen - Andere Route w\u00e4hlen oder an den Support wenden f\u00fcr weitere Informationen" : "Unbekannter Fehlercode (" + urlValue + ")")))))))));
        }
        return returnText;
    }

    public AlarmData run(AlarmData ad) throws Exception {
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.logger.debug("SMSTrade gestartet");
        String text = ad.getPluginMessage();
        if (text.length() >= 160) {
            this.logger.warn("Alarmtext hat mehr als 160 Zeichen");
            if (((Boolean)((GUIElement)this.pluginData.get("concat")).getValue()).booleanValue()) {
                this.logger.info("Alarmtext wird auf 160 Zeichen gek\u00fcrzt");
                text = text.substring(0, 160);
            } else {
                this.logger.warn("Alarmtext nicht gek\u00fcrzt");
            }
        }
        if (((Boolean)((GUIElement)this.pluginData.get("useVerteiler")).getValue()).booleanValue()) {
            this.empfaenger = (String)((GUIElement)this.pluginData.get("verteiler")).getValue();
            this.callURL(this.createURL(text), ad);
        } else {
            List qe;
            ArrayList<String> numbers = null;
            if (this.isQuickEditActive && (qe = ad.getQuickEditLists(new String[]{"mobil"})).size() != 0) {
                this.logger.info("Verwende QuickEdit!");
                this.logger.info("Ziele: {}", (Object)Arrays.toString(qe.toArray()));
                ArrayList<String> numbersTmp = new ArrayList<String>();
                for (String s : qe) {
                    if (!s.matches("(\\d)+")) {
                        this.logger.warn("Ung\u00fcltiges Ziel f\u00fcr dieses Plugin: {}", (Object)s);
                        continue;
                    }
                    numbersTmp.add(s);
                }
                if (numbersTmp.size() != 0) {
                    numbers = numbersTmp;
                    this.logger.info("Anzahl Ziele: {}", (Object)numbers.size());
                }
            }
            if (numbers == null && (this.personsToAlarm.get("mobil") == null || ((List)this.personsToAlarm.get("mobil")).size() == 0)) {
                this.logger.error("Handy Liste enth\u00e4lt keine Eintr\u00e4ge");
                ad.addPluginError("SMSTrade", "Handy Liste enth\u00e4lt keine Eintr\u00e4ge");
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Handy Liste enth\u00e4lt " + ((List)this.personsToAlarm.get("mobil")).size() + " Eintr\u00e4ge");
                }
                String alreadySuccess = ad.getParameter("success");
                String alreadyFailed = ad.getParameter("failed");
                if (numbers == null) {
                    numbers = (ArrayList<String>)this.personsToAlarm.get("mobil");
                }
                ArrayList<String> success = new ArrayList<String>();
                ArrayList<String> failed = new ArrayList<String>();
                if (alreadySuccess.equals("") && alreadyFailed.equals("")) {
                    for (String number : numbers) {
                        this.empfaenger = number.trim();
                        boolean ok = this.callURL(this.createURL(FeedbackUtils.replacePlaceholder((String)ad.getParameter("id"), (String)number, (String)"MOBILE", (String)text)), ad);
                        if (ok) {
                            success.add(number);
                            continue;
                        }
                        failed.add(number);
                    }
                    if (!success.isEmpty()) {
                        ad.addAdditionalInfo("success", this.createStringFromList(success));
                    }
                    if (!failed.isEmpty()) {
                        ad.addAdditionalInfo("failed", this.createStringFromList(failed));
                    }
                } else {
                    String s;
                    int ok;
                    int n;
                    String[] stringArray;
                    this.logger.warn("Vorheriges SMS-Plugin gefunden");
                    if (!alreadyFailed.equals("")) {
                        String[] arrFailed;
                        stringArray = arrFailed = alreadyFailed.split(";");
                        n = arrFailed.length;
                        ok = 0;
                        while (ok < n) {
                            s = stringArray[ok];
                            if (!numbers.contains(s)) {
                                this.logger.warn(String.valueOf(s) + " wird nochmals alarmiert");
                                numbers.add(s);
                            }
                            ++ok;
                        }
                    }
                    if (!alreadySuccess.equals("")) {
                        String[] arrSuccess;
                        stringArray = arrSuccess = alreadySuccess.split(";");
                        n = arrSuccess.length;
                        ok = 0;
                        while (ok < n) {
                            s = stringArray[ok];
                            if (numbers.contains(s)) {
                                this.logger.info(String.valueOf(s) + " wurde bereits vorher erfolgreich alarmiert und wird deswegen entfernt");
                                numbers.remove(s);
                                success.add(s);
                            }
                            ++ok;
                        }
                    }
                    for (String number : numbers) {
                        this.empfaenger = number.trim();
                        ok = this.callURL(this.createURL(FeedbackUtils.replacePlaceholder((String)ad.getParameter("id"), (String)number, (String)"MOBILE", (String)text)), ad) ? 1 : 0;
                        if (ok != 0) {
                            success.add(number);
                            if (!failed.contains(number)) continue;
                            failed.remove(number);
                            continue;
                        }
                        failed.add(number);
                    }
                    ad.addAdditionalInfo("success", this.createStringFromList(success));
                    ad.addAdditionalInfo("failed", this.createStringFromList(failed));
                }
            }
        }
        return ad;
    }

    private String createStringFromList(List<String> list) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            buf.append(list.get(i));
            if (i != list.size() - 1) {
                buf.append(";");
            }
            ++i;
        }
        return buf.toString();
    }

    public int getTimeOut() {
        return 60000;
    }

    public String getDescription() {
        return "Dient zum Versand von SMS \u00fcber die SMSTrade Plattform";
    }

    public String getCurrentVersion() {
        return "1.7";
    }

    public String getAuthor() {
        return "firEmergency";
    }

    public ImageIcon getIcon48() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/smstrade/logo-48.png"));
    }

    public ImageIcon getIcon16() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/smstrade/logo-16.png"));
    }

    public String toString() {
        return "SMSTrade";
    }

    public boolean isQuickEditSupported() {
        return true;
    }
}

