/*
 * Decompiled with CFR 0.152.
 */
package availability;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AvailabilityMapper {
    private int nbrAvailable;
    private int nbrNotAvailable;
    private int nbrTempNotAvailable;
    private String lstOfAvailable = "";
    private String lstOfNotAvailable = "";
    private String lstOfTempNotAvailable = "";
    private String lstOfFunctions = "";
    private String longMessage = "";

    public void addAvailble(String name) {
        ++this.nbrAvailable;
        this.lstOfAvailable = this.lstOfAvailable.concat(String.valueOf(name) + " \n");
    }

    public String getLongMessage() {
        return this.longMessage;
    }

    public void setLongMessage(String longMessage) {
        this.longMessage = longMessage;
    }

    public String getLstOfFunctions() {
        return this.lstOfFunctions;
    }

    public void setLstOfFunctions(String lstOfFunctions) {
        this.lstOfFunctions = lstOfFunctions;
    }

    public void addNotAvailable(String name) {
        ++this.nbrNotAvailable;
        this.lstOfNotAvailable = this.lstOfNotAvailable.concat(String.valueOf(name) + " \n");
    }

    public void addTempNotAvailable(String name) {
        ++this.nbrTempNotAvailable;
        this.lstOfTempNotAvailable = this.lstOfTempNotAvailable.concat(String.valueOf(name) + " \n");
    }

    public int getTotalNbr() {
        return this.nbrAvailable + this.nbrNotAvailable + this.nbrTempNotAvailable;
    }

    public int getPercentageOfAvailable() {
        return this.nbrAvailable / this.getTotalNbr() * 100;
    }

    public int getPercentageOfNotAvailable() {
        return this.nbrNotAvailable / this.getTotalNbr() * 100;
    }

    public int getPercentageOfTempNotAvailable() {
        return this.nbrTempNotAvailable / this.getTotalNbr() * 100;
    }

    public int getNbrAvailable() {
        return this.nbrAvailable;
    }

    public void setNbrAvailable(int nbrAvailable) {
        this.nbrAvailable = nbrAvailable;
    }

    public int getNbrNotAvailable() {
        return this.nbrNotAvailable;
    }

    public void setNbrNotAvailable(int nbrNotAvailable) {
        this.nbrNotAvailable = nbrNotAvailable;
    }

    public int getNbrTempNotAvailable() {
        return this.nbrTempNotAvailable;
    }

    public void setNbrTempNotAvailable(int nbrTempNotAvailable) {
        this.nbrTempNotAvailable = nbrTempNotAvailable;
    }

    public String getLstOfAvailable() {
        return this.lstOfAvailable;
    }

    public void setLstOfAvailable(String lstOfAvailable) {
        this.lstOfAvailable = lstOfAvailable;
    }

    public String getLstOfNotAvailable() {
        return this.lstOfNotAvailable;
    }

    public void setLstOfNotAvailable(String lstOfNotAvailable) {
        this.lstOfNotAvailable = lstOfNotAvailable;
    }

    public String getLstOfTempNotAvailable() {
        return this.lstOfTempNotAvailable;
    }

    public void setLstOfTempNotAvailable(String lstOfTempNotAvailable) {
        this.lstOfTempNotAvailable = lstOfTempNotAvailable;
    }

    public static AvailabilityMapper PARSE(List<Map<String, Object>> dataList) {
        AvailabilityMapper m = new AvailabilityMapper();
        HashMap<String, Integer> funcMap = new HashMap<String, Integer>();
        for (Map<String, Object> data : dataList) {
            if (!data.containsKey("status")) continue;
            String status = (String)data.get("status");
            if (status.equals("AVAILABLE")) {
                String[] functions;
                m.addAvailble((String)data.get("user"));
                if (!data.containsKey("functions")) continue;
                String[] stringArray = functions = ((String)data.get("functions")).split(";");
                int n = functions.length;
                int n2 = 0;
                while (n2 < n) {
                    String function = stringArray[n2];
                    if (!function.equals("")) {
                        if (!funcMap.containsKey(function)) {
                            funcMap.put(function, 1);
                        } else {
                            funcMap.put(function, (Integer)funcMap.get(function) + 1);
                        }
                    }
                    ++n2;
                }
                continue;
            }
            if (status.equals("NOT_AVAILABLE")) {
                m.addNotAvailable((String)data.get("user"));
                continue;
            }
            if (!status.equals("TEMP_NOT_AVAILABLE")) continue;
            m.addTempNotAvailable((String)data.get("user"));
        }
        StringBuffer buf = new StringBuffer();
        for (String key : funcMap.keySet()) {
            String s = String.format("%s: %d verf\u00fcgbar \n", key, funcMap.get(key));
            buf.append(s);
        }
        m.lstOfFunctions = buf.toString();
        buf = new StringBuffer("Tages-Verf\u00fcgbarkeit:\n");
        buf.append(String.format("Verf\u00fcgbar: %d (%d%%)\n", m.nbrAvailable, m.getPercentageOfAvailable()));
        buf.append(String.format("Nicht Verf\u00fcgbar: %d (%d%%)\n", m.nbrNotAvailable, m.getPercentageOfNotAvailable()));
        buf.append(String.format("Bedingt Verf\u00fcgbar: %d (%d%%)\n", m.nbrTempNotAvailable, m.getPercentageOfTempNotAvailable()));
        buf.append(String.format("------- Total: %d -------\n\n", m.getTotalNbr()));
        buf.append(String.format("Verf\u00fcgbar nach Funktion:\n%s", m.getLstOfFunctions()));
        m.longMessage = buf.toString();
        return m;
    }
}

