/*
 * Decompiled with CFR 0.152.
 */
package availability;

import availability.AvailabilityMapper;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import it.sauronsoftware.cron4j.Scheduler;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import org.slf4j.LoggerFactory;
import server.AlarmData;
import server.IAlarmPool;
import server.guielements.Checkbox;
import server.guielements.GUIElement;
import server.guielements.Text;
import server.guielements.Textarea;
import server.input.AbstractInput;

public class AvailabilityInput
extends AbstractInput {
    private static final long serialVersionUID = 1L;
    private static final String HOST = "https://apager-firemergency-2.appspot.com/";
    private static final Type collectionType = new TypeToken<Map<String, Object>>(){}.getType();
    private static final Gson g = new Gson();
    private transient Timer timer;
    private transient Scheduler scheduler;
    private int period = 24;
    private String apiKey = "";
    private long firstStart = 0L;
    private List<String> codes = new ArrayList<String>();

    public AvailabilityInput(IAlarmPool alarmPool) {
        super(alarmPool);
        this.setName("Availability-Input");
    }

    public void run() {
        boolean activ = (Boolean)((GUIElement)this.inputData.get("activ")).getValue();
        if (!activ) {
            return;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy 'um' HH:mm:ss");
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.logger.info("Verf\u00fcgbarkeits-\u00dcberwachung gestartet");
        this.timer = new Timer();
        this.logger.info("\u00dcberpr\u00fcfe Verf\u00fcgbarkeit alle " + this.period + " Stunde(n)");
        Date tmp = new Date(System.currentTimeMillis() + this.firstStart);
        this.logger.info("Erstes \u00dcberpr\u00fcfung am " + formatter.format(tmp));
        this.timer.schedule((TimerTask)new AvailabilityTimer(), this.firstStart, (long)(3600000 * this.period));
    }

    public String toString() {
        return "Verf\u00fcgbarkeits-\u00dcberwachung";
    }

    public String getAuthor() {
        return "firEmergency";
    }

    public String getCurrentVersion() {
        return "0.1";
    }

    public String getDescription() {
        return "Sammelt Informationen zur aktuellen Tages-Verf\u00fcgbarkeit und generiert einen Alarm";
    }

    public ImageIcon getIcon16() {
        return null;
    }

    public ImageIcon getIcon48() {
        return null;
    }

    public Hashtable<String, String> parseAlarm(AvailabilityMapper mapper, String code) {
        Hashtable<String, String> tab = new Hashtable<String, String>();
        tab.put("address", code);
        tab.put("message", mapper.getLongMessage());
        tab.put("avail_available", Integer.toString(mapper.getNbrAvailable()));
        tab.put("avail_not_available", Integer.toString(mapper.getNbrNotAvailable()));
        tab.put("avail_temp_not_available", Integer.toString(mapper.getNbrTempNotAvailable()));
        tab.put("avail_lst_available", mapper.getLstOfAvailable());
        tab.put("avail_lst_not_available", mapper.getLstOfNotAvailable());
        tab.put("avail_lst_temp_not_available", mapper.getLstOfTempNotAvailable());
        tab.put("avail_total", Integer.toString(mapper.getTotalNbr()));
        tab.put("avail_percentage_available", Integer.toString(mapper.getPercentageOfAvailable()));
        tab.put("avail_percentage_not_available", Integer.toString(mapper.getPercentageOfNotAvailable()));
        tab.put("avail_percentage_temp_not_available", Integer.toString(mapper.getPercentageOfTempNotAvailable()));
        tab.put("avail_functions", mapper.getLstOfFunctions());
        tab.put("timestamp", new Date().getTime() + "");
        return tab;
    }

    public void sendAlarmData(final AlarmData arg0) {
        Thread d = new Thread(new Runnable(){

            @Override
            public void run() {
                AvailabilityInput.this.alarmPool.addAlarmData(arg0);
            }
        });
        d.start();
    }

    public void buildGUI() {
        Checkbox element = new Checkbox("Aktivieren", "Schaltet das Availability-Input-Plugin aktiv", 0);
        element.setValue((Object)false);
        this.inputData.put("activ", element);
        element = new Text("Intervall", "Aktualisierungs-Intervall in Stunden", 1);
        element.setValue((Object)"24");
        this.inputData.put("intervall", element);
        element = new Text("Erster Start", "Die erste \u00dcberpr\u00fcfung als Uhrzeit: z.B. 12:45", 2);
        element.setValue((Object)"12:00");
        this.inputData.put("firstStart", element);
        element = new Text("API-Schl\u00fcssel", "API-Schl\u00fcssel welcher \u00fcberpr\u00fcft werden soll", 3);
        this.inputData.put("api", element);
        element = new Textarea("Codes der zu alarmierenden Einheiten", "Geben Sie hier die Einheitencodes an. Jede Zeile entspricht einem Code", 4);
        this.inputData.put("codes", element);
    }

    public void setNewParameters() {
        String[] lines;
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        if (this.inputData.containsKey("api")) {
            this.apiKey = (String)((GUIElement)this.inputData.get("api")).getValue();
        }
        try {
            this.period = Integer.parseInt((String)((GUIElement)this.inputData.get("intervall")).getValue());
        }
        catch (NumberFormatException e) {
            this.logger.error("Falsches Intervall-Format: " + ((GUIElement)this.inputData.get("intervall")).getValue());
        }
        try {
            String time = (String)((GUIElement)this.inputData.get("firstStart")).getValue();
            time = time.trim();
            if (time.matches("([01]?[0-9]|2[0-3]):[0-5][0-9]")) {
                Calendar wished = Calendar.getInstance();
                String hours = time.substring(0, 2);
                String minutes = time.substring(3);
                wished.set(11, Integer.parseInt(hours));
                wished.set(12, Integer.parseInt(minutes));
                wished.set(13, 0);
                Calendar now = Calendar.getInstance();
                if (wished.before(now)) {
                    wished.add(5, 1);
                }
                this.firstStart = wished.getTimeInMillis() - now.getTimeInMillis();
            } else {
                this.logger.error("Ung\u00fcltiges Zeitformat. Zeit muss im 24-Stunden Format vorliegen");
            }
        }
        catch (NumberFormatException e) {
            this.logger.error("Ung\u00fcltiges Zeitformat: " + ((GUIElement)this.inputData.get("firstStart")).getValue(), (Throwable)e);
        }
        this.codes = new ArrayList<String>();
        if (((GUIElement)this.inputData.get("codes")).getValue() == null) {
            return;
        }
        for (String code : lines = ((String)((GUIElement)this.inputData.get("codes")).getValue()).split("\\r?\\n")) {
            this.codes.add(code.trim());
        }
    }

    public void stopInput() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.scheduler != null && this.scheduler.isStarted()) {
            this.scheduler.stop();
        }
        this.logger.info("Availability-Input gestoppt");
    }

    class AvailabilityTimer
    extends TimerTask {
        AvailabilityTimer() {
        }

        @Override
        public void run() {
            AvailabilityInput.this.logger.info("\u00dcberpr\u00fcfe Verf\u00fcgbarkeits-Meldungen...");
            try {
                String s;
                URL url = new URL("https://apager-firemergency-2.appspot.com/feedbackAvailability?api=" + AvailabilityInput.this.apiKey);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuffer buf = new StringBuffer();
                while ((s = rd.readLine()) != null) {
                    buf.append(s);
                }
                rd.close();
                Map data = (Map)g.fromJson(buf.toString(), collectionType);
                if (data.containsKey("data")) {
                    AvailabilityMapper result = AvailabilityMapper.PARSE((List)data.get("data"));
                    Date d = new Date();
                    for (String code : AvailabilityInput.this.codes) {
                        AvailabilityInput.this.sendAlarmData(new AlarmData(AvailabilityInput.this.parseAlarm(result, code), d));
                    }
                } else {
                    AvailabilityInput.this.logger.warn("Keine Daten vorhanden");
                }
            }
            catch (Exception e) {
                AvailabilityInput.this.logger.error("Verf\u00fcgbarkeit konnte nicht aktualisiert werden", (Throwable)e);
            }
        }
    }
}

