<!--
Das folgende File setzt eine Log-Datei des Monitor-Programms von Markus Grohmann
in eine html-Ausgabe um, um sie ber das LAN allen angeschlossenen Rechnern unabhn- 
gig vom OS zur Verfgung zu stellen.Dazu wird die Reihenfolge der Eintrge wieder in 
die richtige Form gebracht (neueste Eintrge oben) und es wird eine Tabelle erzeugt, 
in die die Eintrge einsortiert werden.
Das Logfile bleibt dabei unangetastet.
Voraussetzung: Auf dem Rechner, auf dem Monitor luft, mu auch ein Webserver mit PHP-
Untersttzung laufen (Linux, Apache, PHP).
Bisher werden nur POCSAG-Entschlsselungen richtig umgesetzt. Das File ist auch nur eine
allererste Skizze. Mehr wird folgen - hoffentlich.
Um das File anwenden zu knnen, mu die POCSAG-Zeile in der .monrc wie folgt aussehen:
POCSAG:Zeit8 NUMMER7 FUNC17 NAME15 DME
Wollt Ihr andere Formatierungen verwenden, mt Ihr die Zeilen, die mit
echo substr($array ...
beginnen, an Eure Formatierung anpassen.
Das File ldt sich selbststndig alle 10 Sekunden neu, somit bleiben die Ausgaben immer
aktuell. Bitte pat den Inhalt von $logpath an. Schreibt dort bitte den Pfad zu Euren
Log-Dateien auf. Ich gehe davon aus, da die Log-Dateien den Namen "log_YYYY-MM-DD.log" 
tragen, wobei YYYY das Jahr, MM den Monat und DD den Tag bezeichnet.
Wenn Ihr konstruktive Verbesserungen programmiert, schickt sie mir bitte, damit die Weiter-
entwicklung dieser Idee nicht in 1000 Richtungen und damit fast automatisch in den
Sand luft.
---------------
neue Features:
Jetzt kann man sich durch lange Listen seitenweise durchblttern. Auerdem kann man mit
Knpfen fr Tag/Monat/Jahr +/- andere Daten anwhlen. Mit "aktuell" kommt man jederzeit
auf die aktuelle Liste zurck. Es handelt sich bei der Datumswahl _nicht_ um eine logische
Abfrage, sondern nur um "rauf oder runter" der aktuellen Zahl. Fr Daten, die nicht existieren
wird einfach eine nicht vorhandene Datei angezeigt.
---------------
Viel Spa mit den neuen Features!

Meine Mail: funkwart@everymail.net
-->

<html>
<head>
<title>Logfile vom Monitor-Server</title>
</head>

<body>
<?PHP

$logpath = "/home/hk/monlog/";

//Die folgende if-Abfrage ist fr den Fall, da die Seite ber ein vorgeschaltetes
//Abfrageformular fr ein bestimmtes Datum aufgerufen wird. Bisher wird, da die erwarteten
//Variablen leer sind, automatisch das aktuelle File geffnet, so es denn schon existiert.

if(empty($_REQUEST['Year'])){
    $Year=date("Y");
    }
else{
    $Year=$_REQUEST['Year'];
    }
if(empty($_REQUEST['Month'])){
    $Month=date("m");
    }
else{
    if($_REQUEST['Month']<10){
	$Month="0".$_REQUEST['Month'];
	}
    else{
	$Month=$_REQUEST['Month'];
	}
    }
if(empty($_REQUEST['Day'])){
    $Day=date("d");
    }
else{
    if($_REQUEST['Day']<10){
	$Day="0".$_REQUEST['Day'];
	}
    else{
	$Day=$_REQUEST['Day'];
	}
    }

$datdate = $Year."-".$Month."-".$Day;

$datei = $logpath."log_".$datdate.".log";
if(file_exists($datei)){
    $array = file($datei);
    }
else{
    //echo "Die Datei ist nicht existent, es wird nichts ausgegeben.";
    $array = array("###############################################","#########");
    }

$eintrag = (count($array)/2);
$seiten = (count($array)/40); //20 Eintrge pro Seite
$seiten = ceil($seiten);
if(empty($_REQUEST['seite_id'])){
    $seite_id=1;
    }
else{
    $seite_id=$_REQUEST['seite_id'];
    }
$anfang = (($seite_id*20)-20);
if($eintrag<($seite_id*20)){
    $ende = $eintrag;
    }
else{
    $ende = (($seite_id*20));
    }


echo "<h1>Logfile fr den ".substr($datdate, 8, 2).". ".substr($datdate, 5, 2).". ".substr($datdate, 0, 4)." </h1>";
echo "<br>Stand: ".date("d.m.Y, H:i:s");
echo "<br>Eintrge: ".$eintrag;
echo "<br><hr>";
echo "<table border=\"1\">";
echo "<tr><th>Nr.</th><th>Uhrzeit</th><th>Schleife</th><th>Auslsung</th><th>Empfnger</th><th>Meldung</th></tr>";
for($x=$anfang;$x<$ende;$x++){
    echo "<tr><td>";
    echo (($x)+1);
    echo "</td><td>";
    echo substr($array[count($array)-(($x*2)+2)], 0, 8);
    echo "</td><td>";
    echo substr($array[count($array)-(($x*2)+2)], 9, 7);
    echo "</td><td>";
    echo substr($array[count($array)-(($x*2)+2)], 17, 17);
    echo "</td><td>";
    echo substr($array[count($array)-(($x*2)+2)], 35, 15);
    echo "</td><td>";
    echo $array[count($array)-(($x*2)+1)];
    echo "</td></tr>";
}
echo "</table>";

$dayp=$Day-1;
$daya=$Day*1;
$dayn=$Day+1;
$monthp=$Month-1;
$montha=$Month*1;
$monthn=$Month+1;
$yearp=$Year-1;
$yearn=$Year+1;

echo "<div>";
if($seite_id>1){
    $seitep=$seite_id-1;
    echo " <a href='".$PHP_SELF."?seite_id=$seitep&Year=$Year&Month=$montha&Day=$daya'>&lt;</a> ";
    echo " - ";
    }
for($y=1;$y<=$seiten;$y++){
    if($y==$seite_id){
	echo "$y ";
	}
    else{
	echo " <a href='".$PHP_SELF."?seite_id=$y&Year=$Year&Month=$montha&Day=$daya'>$y</a> ";
	}
    if($y<$seiten){
	echo " - ";
	}
    }
if($seiten>$seite_id){
    $seiten=$seite_id+1;
    echo " -  <a href='".$PHP_SELF."?seite_id=$seiten&Year=$Year&Month=$montha&Day=$daya'>&gt;</a> ";
    }
echo "</div><br>";


echo " <a href='".$PHP_SELF."?seite_id=1&Year=$yearp'>(-Y)</a> ";
echo " - ";
echo " <a href='".$PHP_SELF."?seite_id=1&Month=$monthp'>(-M)</a> ";
echo " - ";
echo " <a href='".$PHP_SELF."?seite_id=1&Day=$dayp'>(-D)</a> ";
echo " - ";
echo " <a href='".$PHP_SELF."?seite_id=1'>aktuell</a> ";
echo " - ";
echo " <a href='".$PHP_SELF."?seite_id=1&Day=$dayn'>(+D)</a> ";
echo " - ";
echo " <a href='".$PHP_SELF."?seite_id=1&Month=$monthn'>(+M)</a> ";
echo " - ";
echo " <a href='".$PHP_SELF."?seite_id=1&Year=$yearn'>(+Y)</a> ";



?>

<script language="JavaScript">
setTimeout( 'location.reload(true)', 10000 );
</script>

</body>
</html>