/*
 * Decompiled with CFR 0.152.
 */
package mailInput;

import com.sun.mail.iap.ProtocolException;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.protocol.IMAPProtocol;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Part;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.event.MessageCountAdapter;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.swing.ImageIcon;
import mailInput.SchluesselwortMailInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import server.AlarmData;
import server.IAlarmPool;
import server.backup.EServerMode;
import server.backup.IServerModeChangedListener;
import server.guielements.Checkbox;
import server.guielements.GUIElement;
import server.guielements.Label;
import server.guielements.Password;
import server.guielements.Text;
import server.guielements.Textarea;
import server.input.AbstractInput;

public class MailInput
extends AbstractInput
implements IServerModeChangedListener {
    private static final long serialVersionUID = 1L;
    private String mailserver = "";
    private String username = "";
    private String password = "";
    private String fold = "INBOX";
    private transient Timer timer;
    private transient List<InternetAddress> validMailsAsAddress = new ArrayList<InternetAddress>();
    private List<String> validMails = new ArrayList<String>();
    private boolean isSSL = true;
    private transient Store store;
    private String fallback = "";
    private String separator = ";";
    private Integer delayTimer = new Integer(25);
    private transient List<String> regexMailAdresses = new ArrayList<String>();
    private Boolean isHTML = true;
    private final List<SchluesselwortMailInput> keywords = new ArrayList<SchluesselwortMailInput>();
    private transient IMAPFolder folder;
    private transient Session session;
    private transient Thread keepAliveThread;

    public MailInput(IAlarmPool alarmPool) {
        super(alarmPool);
        this.setName("Mail-Input");
        this.setDaemon(true);
    }

    public MailInput(IAlarmPool alarmPool, int port) {
        super(alarmPool);
        this.setName("Mail-Input");
    }

    public void run() {
        boolean activ = (Boolean)((GUIElement)this.inputData.get("activ")).getValue();
        if (this.inputData.containsKey("HTML")) {
            this.isHTML = (Boolean)((GUIElement)this.inputData.get("HTML")).getValue();
        }
        if (this.separator == null) {
            this.separator = ";";
        }
        this.isSSL = true;
        if (!activ) {
            return;
        }
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.logger.info("Mail-\u00dcberwachung gestartet");
        EServerMode mode = EServerMode.STANDALONE;
        try {
            Method method = Class.forName("server.backup.MasterSlaveController").getMethod("getInstance", null);
            Object controller = method.invoke(null, new Object[0]);
            Method getMode = controller.getClass().getMethod("getMode", null);
            mode = (EServerMode)getMode.invoke(controller, new Object[0]);
            method = controller.getClass().getMethod("addListener", IServerModeChangedListener.class);
            method.invoke(controller, new Object[]{this});
        }
        catch (Exception e) {
            this.logger.error("Konnte FE-Server-Modus nicht laden", (Throwable)e);
        }
        this.logger.debug("Server-Modus: " + mode);
        this.validMailsAsAddress = new ArrayList<InternetAddress>();
        this.regexMailAdresses = new ArrayList<String>();
        for (String s : this.validMails) {
            this.logger.debug("\u00dcberp\u00fcrfe " + s + " als g\u00fcltigen Absender.");
            try {
                if (s.startsWith("*@")) {
                    this.regexMailAdresses.add(s.substring(1));
                    this.logger.debug(String.valueOf(s.substring(1)) + " hinzugef\u00fcgt als Regex-Absender");
                    continue;
                }
                this.validMailsAsAddress.add(new InternetAddress(s));
                this.logger.debug(String.valueOf(s) + " hinzugef\u00fcgt als Absender");
            }
            catch (AddressException e) {
                this.logger.warn("Ung\u00fcltiges Mail-Format", (Throwable)e);
            }
        }
        switch (mode) {
            case SLAVE: {
                this.logger.info("FE ist im Slave Modus. Postfach wird NICHT \u00fcberwacht");
                break;
            }
            default: {
                this.startConnectingToMail();
            }
        }
    }

    private void startConnectingToMail() {
        this.logger.debug("Verbinde mit Postfach");
        Properties props = new Properties();
        props.setProperty("mail.imaps.host", this.mailserver);
        props.setProperty("mail.imaps.user", this.username);
        props.setProperty("mail.imaps.password", this.password);
        props.setProperty("mail.imaps.auth", "true");
        props.setProperty("mail.imaps.starttls.enable", "true");
        props.setProperty("mail.imaps.socketFactory.port", String.valueOf(993));
        props.setProperty("mail.imaps.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.setProperty("mail.imaps.socketFactory.fallback", "false");
        while (true) {
            System.out.println("##########Connection RESET ######");
            try {
                Authenticator auth = null;
                auth = new Authenticator(){

                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(MailInput.this.username, MailInput.this.password);
                    }
                };
                this.connectToStore(props, auth);
                continue;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
                this.logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void connectToStore(Properties props, Authenticator auth) throws NoSuchProviderException, MessagingException {
        if (this.store != null && this.store.isConnected()) {
            this.store.close();
        }
        this.logger.debug("Verbinde zu " + this.mailserver + "@" + this.username + "(imapSSL)... ");
        this.session = Session.getInstance((Properties)props, (Authenticator)auth);
        this.store = this.isSSL ? this.session.getStore("imaps") : this.session.getStore("imap");
        this.store.connect();
        this.logger.info("Verbindung erfolgreich hergestellt");
        this.folder = (IMAPFolder)this.store.getFolder(this.fold);
        this.folder.addMessageCountListener((MessageCountListener)new MessageCountAdapter(){

            public void messagesAdded(MessageCountEvent e) {
                try {
                    MailInput.this.logger.info("Neue Nachrichten sind eingetroffen");
                    MailInput.this.newMessageAdded(e);
                }
                catch (Exception e1) {
                    MailInput.this.logger.error(e1.getMessage(), (Throwable)e1);
                }
            }

            public void messagesRemoved(MessageCountEvent e) {
                super.messagesRemoved(e);
            }
        });
        this.folder.open(2);
        this.logger.debug("Ordner: Schreib/Lese Rechte erhalten");
        this.startListening(this.folder);
        this.logger.debug("Postfach wird nun abgeh\u00f6rt");
    }

    protected void newMessageAdded(MessageCountEvent e) throws MessagingException, IOException {
        Message[] messages;
        Message[] messageArray = messages = e.getMessages();
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            Message message = messageArray[n2];
            Address[] address = message.getFrom();
            if (this.validMailsAsAddress != null) {
                boolean isRegex = false;
                for (String regexAddress : this.regexMailAdresses) {
                    this.logger.debug("RegexAddress: " + regexAddress + " compared to " + address[0].toString());
                    if (!address[0].toString().contains(regexAddress)) continue;
                    this.logger.info("Absenderaddresse f\u00e4llt in Regex-Filter f\u00fcr " + regexAddress.toString());
                    isRegex = true;
                    break;
                }
                this.logger.debug("RegexValue: " + isRegex);
                if (this.validMailsAsAddress.contains(address[0]) || isRegex) {
                    this.logger.info("Eingegangene Email ist berechtigt eine Alamierung auszul\u00f6sen (" + address[0] + ")!");
                    String subject = "";
                    if (!this.fallback.equals("")) {
                        this.logger.debug("Verwende Standardalamierungseinheit " + this.fallback);
                        subject = this.fallback.trim();
                    } else {
                        subject = message.getSubject();
                        this.logger.debug("Folgende Einheiten alamieren: " + subject);
                    }
                    String text = this.getText((Part)message);
                    this.logger.debug("Messagetext:\n" + text);
                    if (this.isHTML != null) {
                        if (this.isHTML.booleanValue()) {
                            text = this.cleanText(text);
                        }
                    } else {
                        this.logger.debug("isHTML was NULL");
                        text = this.cleanText(text);
                    }
                    if (this.inputData.containsKey("newline") && ((Boolean)((GUIElement)this.inputData.get("newline")).getValue()).booleanValue()) {
                        this.logger.debug("Zeilenumbr\u00fcche werden entfernt...");
                        text = text.replaceAll("\n\r", " ");
                        text = text.replaceAll("\n", " ");
                        text = text.replaceAll("\r", " ");
                    }
                    this.logger.debug("Clean-Messagetext:\n" + text);
                    this.logger.debug("Text erfolgreich ausgelesen");
                    if (!subject.equals("")) {
                        if (this.separator == null) {
                            this.separator = ";";
                        }
                        this.logger.debug(String.format("Trenne Betreff '%s' mit Trennzeichen '%s'", subject, this.separator));
                        if (subject.contains(this.separator)) {
                            String[] units;
                            String[] stringArray = units = subject.split(this.separator);
                            int n3 = units.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String unit = stringArray[n4];
                                Date date = new Date();
                                this.sendAlarmData(new AlarmData(this.parseAlarm(text, subject, unit), date));
                                this.logger.info("Neuen Alarm f\u00fcr " + unit + " erstellt!");
                                ++n4;
                            }
                        } else {
                            Date date = new Date();
                            this.sendAlarmData(new AlarmData(this.parseAlarm(text, subject, subject), date));
                            this.logger.info("Neuen Alarm f\u00fcr " + subject + " erstellt!");
                        }
                    }
                } else {
                    this.logger.warn("Eingegangene Email ist nicht berechtigt eine Alamierung auszul\u00f6sen (" + address[0] + ")!");
                }
            }
            if (!message.isExpunged()) {
                message.setFlag(Flags.Flag.DELETED, true);
            }
            this.logger.debug("Nachricht im Postfach gel\u00f6scht!");
            ++n2;
        }
    }

    public void startListening(IMAPFolder imapFolder) {
        if (this.keepAliveThread != null && this.keepAliveThread.isAlive()) {
            this.keepAliveThread.interrupt();
        }
        this.keepAliveThread = new Thread((Runnable)new KeepAliveRunnable(imapFolder), "IdleConnectionKeepAlive");
        this.keepAliveThread.start();
        while (!Thread.interrupted()) {
            try {
                imapFolder.idle();
            }
            catch (MessagingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String cleanText(String text) {
        while (text.contains("<")) {
            String substring = text.substring(text.indexOf("<"), text.indexOf(">") + 1);
            this.logger.debug("Tag to be removed: " + substring);
            text = substring.equals("<br>") ? text.replace(substring, "\n") : text.replace(substring, "");
        }
        if (text.contains("&nbsp;")) {
            text = text.replace("&nbsp;", "\n");
        }
        return text;
    }

    private String getText(Part p) throws MessagingException, IOException {
        if (p.isMimeType("text/*")) {
            String s = (String)p.getContent();
            return s;
        }
        if (p.isMimeType("multipart/alternative")) {
            Multipart mp = (Multipart)p.getContent();
            String text = null;
            int i = 0;
            while (i < mp.getCount()) {
                BodyPart bp = mp.getBodyPart(i);
                if (bp.isMimeType("text/plain")) {
                    if (text == null) {
                        text = this.getText((Part)bp);
                    }
                } else if (bp.isMimeType("text/html")) {
                    String s = this.getText((Part)bp);
                    if (s != null) {
                        return s;
                    }
                } else {
                    return this.getText((Part)bp);
                }
                ++i;
            }
            return text;
        }
        if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            int i = 0;
            while (i < mp.getCount()) {
                String s = this.getText((Part)mp.getBodyPart(i));
                if (s != null) {
                    return s;
                }
                ++i;
            }
        }
        return null;
    }

    public String toString() {
        return "Mail-Eingang \u00dcberwachung";
    }

    public String getAuthor() {
        return "FirEmergency";
    }

    public String getCurrentVersion() {
        return "2.1";
    }

    public String getDescription() {
        return "\u00dcberwacht ein eMail-Postfach und alarmiert bei einer neuen Mail.";
    }

    public ImageIcon getIcon16() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/mailInput/logo-16.png"));
    }

    public ImageIcon getIcon48() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/mailInput/logo-48.png"));
    }

    public Hashtable<String, String> parseAlarm(String message, String subject, String code) {
        Hashtable<String, String> tab = new Hashtable<String, String>();
        tab.put("address", code);
        if (message != null) {
            message = message.trim();
        }
        if (message == null || message.equals("") || message.equals("\r\n")) {
            message = "N/A";
        }
        tab.put("message", message);
        if (this.keywords != null && this.keywords.size() != 0) {
            tab.putAll(this.createData(message));
        }
        tab.put("subject", subject);
        tab.put("timestamp", String.valueOf(new Date().getTime()));
        return tab;
    }

    private Map<String, String> createData(String message) {
        HashMap<String, String> keys = new HashMap<String, String>();
        try {
            message = message.trim().replaceAll("( )+", " ");
            for (SchluesselwortMailInput keyword : this.keywords) {
                String value;
                int end;
                int start;
                String tmpKeyword = keyword.from.toLowerCase();
                String tmpAlarm = message.toLowerCase();
                if (tmpAlarm.indexOf(tmpKeyword) != -1) {
                    start = tmpAlarm.indexOf(tmpKeyword) + tmpKeyword.length();
                    end = tmpAlarm.length();
                    value = "N/A";
                    if (keyword.to == null) {
                        value = message.substring(start);
                    } else {
                        end = tmpAlarm.substring(start).indexOf(keyword.to.toLowerCase());
                        this.logger.debug("Start: " + start + " Ende: " + end + " L\u00e4nge: " + message.length());
                        if (end == -1) {
                            if (!keyword.to.equals("")) {
                                this.logger.warn(String.format("Ende (%s) nicht gefunden", keyword.to));
                            }
                            value = message.substring(start);
                        } else {
                            value = message.substring(start, end += start);
                        }
                    }
                    keys.put(keyword.key, value);
                    this.logger.debug(String.format("Hinzugef\u00fcgt: '%s' als '%s'", keyword.key, value));
                    continue;
                }
                if (tmpAlarm.indexOf(tmpKeyword = tmpKeyword.replaceAll(" ", "")) == -1) continue;
                start = tmpAlarm.indexOf(tmpKeyword) + tmpKeyword.length();
                end = tmpAlarm.length();
                value = "N/A";
                if (keyword.to == null) {
                    value = message.substring(start);
                } else {
                    end = tmpAlarm.substring(start).indexOf(keyword.to.toLowerCase());
                    this.logger.debug("Start: " + start + " Ende: " + end + " L\u00e4nge: " + message.length());
                    if (end == -1) {
                        if (!keyword.to.equals("")) {
                            this.logger.warn(String.format("Ende (%s) nicht gefunden", keyword.to));
                        }
                        value = message.substring(start);
                    } else {
                        value = message.substring(start, end += start);
                    }
                }
                keys.put(keyword.key, value);
                this.logger.debug(String.format("Added: '%s' als '%s'", keyword.key, value));
            }
            return keys;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Fehler beim Erkennen der Schl\u00fcsselw\u00f6rter: " + e.getLocalizedMessage() + " - " + e.getClass().getSimpleName(), (Throwable)e);
            return keys;
        }
    }

    public void sendAlarmData(AlarmData arg0) {
        this.logger.debug("Fuege Alarm dem Pool hinzu");
        this.alarmPool.addAlarmData(arg0);
    }

    public void buildGUI() {
        Label element = new Label("Dieses InputPlugin dient zur Anbindung eines Email-Postfachs f\u00fcr Alamierungen. Aus Sicherheitsgr\u00fcnden werden dabei nur IMAPS Konten unterst\u00fctzt, d.h. IMAP Konten die SSL unterst\u00fctzen", "Beschreibung", 0);
        this.inputData.put("description", element);
        element = new Checkbox("Aktivieren", "Schaltet das Alive-Input-Plugin aktiv", 1);
        element.setValue((Object)false);
        this.inputData.put("activ", element);
        element = new Text("Benutzername", "Benutzername des Email-Kontos", 2);
        element.setValue((Object)"Benutzername");
        this.inputData.put("username", element);
        element = new Password("Passwort", "Passwort des Email-Kontos", 3);
        element.setValue((Object)"password");
        this.inputData.put("password", element);
        element = new Text("Posteingangsserver", "Adresse des Posteingangsserver", 4);
        element.setValue((Object)"imap.beispiel.de");
        this.inputData.put("server", element);
        element = new Text("Ordner", "Ordner des Email-Kontos der \u00fcberwacht werden soll", 5);
        element.setValue((Object)"INBOX");
        this.inputData.put("folder", element);
        element = new Textarea("Absender-Email", "Diese Email-Adressen sind berechtigt um Alamierungen auszul\u00f6sen.\nJede Zeile entspricht einer Absenderadresse", 6);
        this.inputData.put("from", element);
        element.setValue((Object)"");
        element = new Text("Alarmierungseinheit", "Wird diese Einheit/en eingetragen, so wird immer diese Einheit alamiert.\n\rDer Betreff wird dann als Alamierungsziel ignoriert!\n\rMehrere Einheiten im folgenden Format 12345;23456", 7);
        element.setValue((Object)"");
        this.inputData.put("fallback", element);
        element = new Text("Einheiten-Trennzeichen im Betreff", "Wie die Einheitencodes im Betreff getrennt werden sollen", 8);
        element.setValue((Object)";");
        this.inputData.put("sep", element);
        element = new Checkbox("HTML", "HTML Tags werden der Nachricht entfernt. Nur deaktivieren, wenn es sich um keine HTML codierten Emails handelt.", 9);
        element.setValue((Object)true);
        this.inputData.put("HTML", element);
        element = new Checkbox("Zeilenumbr\u00fcche entfernen", "Enthaltene Zeilenumbr\u00fcche werden entfernt", 10);
        element.setValue((Object)false);
        this.inputData.put("newline", element);
        element = new Textarea("Schl\u00fcsselw\u00f6rter (optional)", "Bitte auf Formatierung achten. Siehe Link", 11);
        this.inputData.put("keywords", element);
        element = new Text("Connection Refresh", "Zeit (in Min) bis Verbindung zum Postfach neu aufgebaut wird. [Standard 25 min] Starten Sie den Server neu, wenn Sie diesen Paramter \u00e4ndern!", 12);
        element.setValue((Object)"25");
        this.inputData.put("delay", element);
    }

    public void setNewParameters() {
        int n;
        int n2;
        String[] stringArray;
        this.validMailsAsAddress = new ArrayList<InternetAddress>();
        this.validMails = new ArrayList<String>();
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        }
        if (this.inputData.get("username") != null) {
            this.username = ((String)((GUIElement)this.inputData.get("username")).getValue()).trim();
        }
        if (this.inputData.get("password") != null) {
            this.password = ((String)((GUIElement)this.inputData.get("password")).getValue()).trim();
        }
        if (this.inputData.get("server") != null) {
            this.mailserver = ((String)((GUIElement)this.inputData.get("server")).getValue()).trim();
        }
        if (this.inputData.get("folder") != null) {
            this.fold = ((String)((GUIElement)this.inputData.get("folder")).getValue()).trim();
        }
        if (this.inputData.get("sep") != null) {
            this.separator = ((String)((GUIElement)this.inputData.get("sep")).getValue()).trim();
        }
        if (this.inputData.get("from") != null) {
            try {
                String[] froms;
                stringArray = froms = ((String)((GUIElement)this.inputData.get("from")).getValue()).split("\\s|" + System.getProperty("line.separator"));
                n2 = froms.length;
                n = 0;
                while (n < n2) {
                    String from = stringArray[n];
                    String string = from;
                    if (string != null && !string.equals("")) {
                        if (!this.validateMailAddress(string)) {
                            this.logger.info("Berechtigungs-Adresse besitzt kein korrektes Format \"adresse@host.domain\"");
                        }
                        this.validMailsAsAddress.add(new InternetAddress(string));
                        this.validMails.add(string.trim());
                    }
                    ++n;
                }
            }
            catch (AddressException e) {
                this.logger.error("Falsches Email-Format: " + ((GUIElement)this.inputData.get("from")).getValue());
            }
        }
        if (this.inputData.get("fallback") != null) {
            this.fallback = ((String)((GUIElement)this.inputData.get("fallback")).getValue()).trim();
        }
        if (this.inputData.get("delay") != null) {
            this.delayTimer = new Integer(((String)((GUIElement)this.inputData.get("delay")).getValue()).trim());
        }
        if (this.inputData.containsKey("keywords") && ((GUIElement)this.inputData.get("keywords")).getValue() != null) {
            String[] lines;
            this.keywords.clear();
            stringArray = lines = ((String)((GUIElement)this.inputData.get("keywords")).getValue()).split("\\r?\\n");
            n2 = lines.length;
            n = 0;
            while (n < n2) {
                String value;
                String key;
                String line = stringArray[n];
                String[] arr = line.split(";");
                if (arr.length == 2) {
                    key = arr[0];
                    value = arr[1];
                    this.logger.info(String.format("Neues Schl\u00fcsselwort: Von '%s' bis '%s' wird gespeichert als '%s'", key, value, key));
                    this.keywords.add(new SchluesselwortMailInput(key, value, key));
                } else if (arr.length == 3) {
                    key = arr[0];
                    value = arr[1];
                    String keyToSave = arr[2];
                    if (value.equals("")) {
                        this.logger.info(String.format("Neues Schl\u00fcsselwort: Von '%s' bis ENDE wird gespeichert als '%s'", key, value, keyToSave));
                    } else {
                        this.logger.info(String.format("Neues Schl\u00fcsselwort: Von '%s' bis '%s' wird gespeichert als '%s'", key, value, keyToSave));
                    }
                    this.keywords.add(new SchluesselwortMailInput(key, value, keyToSave));
                } else {
                    this.logger.debug("Ung\u00fcltiges Schl\u00fcsselwort: " + line);
                }
                ++n;
            }
        }
    }

    public void stopInput() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.logger.info("Mail-Input gestoppt");
        }
        try {
            Method method = Class.forName("server.backup.MasterSlaveController").getMethod("getInstance", null);
            Object controller = method.invoke(null, new Object[0]);
            method = controller.getClass().getMethod("removeListener", IServerModeChangedListener.class);
            method.invoke(controller, new Object[]{this});
        }
        catch (Exception e) {
            this.logger.error("Listener konnte nicht entfernt werden", (Throwable)e);
        }
    }

    private boolean validateMailAddress(String mailAddress) {
        return mailAddress.contains("@") && mailAddress.substring(mailAddress.indexOf("@")).contains(".");
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.store.close();
        this.logger.debug("Verbindung zum Postfach beendet!");
    }

    public void serverModeChanged(EServerMode arg0) {
        this.logger.info("Server-Modus hat sich ge\u00e4ndert: " + arg0);
        switch (arg0) {
            case SLAVE: {
                this.logger.info("Stoppe Postfach\u00fcberwachung");
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer.purge();
                }
                if (this.store == null || !this.store.isConnected()) break;
                try {
                    this.store.close();
                }
                catch (MessagingException e) {
                    this.logger.error("Postfach konnte nicht geschlossen werden", (Throwable)e);
                }
                break;
            }
            default: {
                this.startConnectingToMail();
            }
        }
    }

    private static class KeepAliveRunnable
    implements Runnable {
        private static final long KEEP_ALIVE_FREQ = 300000L;
        private Logger logger = LoggerFactory.getLogger(this.getClass());
        private IMAPFolder folder;

        public KeepAliveRunnable(IMAPFolder folder) {
            this.folder = folder;
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    Thread.sleep(300000L);
                    this.folder.doCommand(new IMAPFolder.ProtocolCommand(){

                        public Object doCommand(IMAPProtocol p) throws ProtocolException {
                            p.simpleCommand("NOOP", null);
                            return null;
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
            }
        }
    }
}

