#!/usr/bin/python

from thread import start_new_thread;
from Event import Event;

class SerialPort():
    def __init__(self, port, baud, eol_char='\r\n'):
        self.classname = "SerialPort()";
        functionname = "__init__()";
        
        # Pruefen ob 'port' vom Typ String ist
        if not isinstance(port, str):
            print self.classname + " " + functionname + " " + "ERROR" + " " + "Falscher Datentyp: 'port'";
            return False;
        
        # Pruefen ob 'baud' vom Typ Integer ist
        if not isinstance(baud, int):
            print self.classname + " " + functionname + " " + "ERROR" + " " + "Falscher Datentyp: 'baud'";
            return False;
        
        # Pruefen ob 'eol_char' vom Typ String ist
        if not isinstance(eol_char, str):
            print self.classname + " " + functionname + " " + "ERROR" + " " + "Falscher Datentyp: 'eol_char'";
            return False;
        
        # Baudrate pruefen
        baudliste = [(1200), (2400),(4800), (9600), (19200), (28800), (38400)];

        if not baud in baudliste:
            print self.classname + " " + functionname + " " + "ERROR" + " " + "Baudrate nicht bekannt";
            self.__del__();
            return False;
        
        # EOL-Char ablegen
        self.eol_char = eol_char;
        
        # DataReceived-Event erstellen
        self.data_received = Event();

        # Flags fuer die Thread-Unterbrechung erstellen
        self.ListenerThread_run = False;
        self.ListenerThread_running = False;
        
        # Port oeffnen
        self.Open(port, baud);
        
    def __del__(self):
        # Port schliessen
        self.Close();
        
    def Open(self, port, baud):
        functionname = "Open()";
        
        try:
            # Port ersttellen & oeffnen
            self.port = serial.Serial(port, baud, timeout=0.01);
            self.port.open();
            print self.classname + " " + functionname + " " + "INFO" + " " + "Serielle Schnittstelle geoeffnet";
            
            # Flag fuer ListenerThread erstellen & Thread starten
            self.ListenerThread_run = True;
            start_new_thread(self.ListenerThread,());
        except:
            print self.classname + " " + functionname + " " + "ERROR" + " " + "Serielle Schnittstelle konnte nicht geoeffnet werden";
            
    def Close(self):
        functionname = "Close()";
        
        try:
            # Das Flag um den ListenerThread zu steuern wird auf 'False' gesetzt
            self.ListenerThread_run = False;
            
            # Warten bis der ListenerThread tatsaechlich beendet ist
            while self.ListenerThread_running:
                pass;
            
            # Port schliesen
            self.port.close();
            
            print self.classname + " " + functionname + " " + "INFO" + " " + "Serielle Schnittstelle wurde geschlossen";
        except:
            pass;
    
    def ListenerThread(self):
        buffer = "";
        data = "";
        
        # Schleife fuer das staendige Lesen der Schnittstelle
        # Wird beendet, wenn 'self.ListenerThread_run' den Zustand 'False' hat
        while self.ListenerThread_run:
            # Vorhandene Zeichen von der Schnittstelle lesen
            buffer = self.port.readline();
            
            # Empfangene Zeichen an Variable 'data' anhaengen und 'buffer' leeren
            data += buffer;
            buffer =  "";
            
            # Pruefen ob EOL-Char in 'data' enthalten ist
            if self.eol_char in data:
                # DataReceived-Event ausloesen und 'data' leeren
                self.data_received(data);
                data = "";
            
            # Flag zum zeigen, dass ListenerThread noch laeuft auf 'True' setzen
            self.ListenerThread_running = True;

        # ListenerThread-Flag auf 'False' zuruecksetzen
        self.ListenerThread_running = False;

def DataReceivedHandler(data):
    # Diese Funktion wird ausgefuehrt, wenn an dem Port ein String empfangen wurde, der das EOL-Zeichen enthaelt (endet)
    print "Daten empfangen: " + str(data);
    
if __name__ == "__main__":

    # Neue Klasseninstanz erzeugen
    # port = /dev/ttyUSB0
    # baud = 9600
    # eol_char = '\0'
    port = SerialPort("/dev/ttyUSB0", 9600, '\0');
    
    # DataReceived-Event erstellen
    port.data_received += DataReceivedHandler;
    
    # Das Programm wartet auf eine ("Enter"-)Eingabe vom User
    raw_input();
    # Anschliessend wird das Programm beendet
    port.Close();