/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AddressGrapper {
    private static String plz = null;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Aufruf: java -jar AddressGrapper.jar ORT");
            return;
        }
        String city = args[0];
        List<String> streets = AddressGrapper.getAllStreetsForCity(city);
        AddressGrapper.saveStreetList(city, city, plz, streets);
    }

    private static void saveStreetList(String city, String abbr, String postal, List<String> streets) throws Exception {
        File file = new File(String.valueOf(city) + ".csv");
        BufferedWriter wr = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("ISO-8859-15")));
        Collections.sort(streets);
        for (String street : streets) {
            wr.write(String.format("%s;%s;%s;%s\n", city, abbr, postal, street));
        }
        wr.flush();
        wr.close();
        System.out.println("Strassen zu Datei geschrieben: " + file.getAbsolutePath());
    }

    private static List<String> getAllStreetsForCity(String city) throws Exception {
        System.out.println("Starte...");
        ArrayList<String> streets = new ArrayList<String>();
        int i = 97;
        while (i <= 122) {
            String s;
            String letter = Character.toString((char)i);
            String url = String.format("http://www.meinestadt.de/%s/stadtplan/strassenverzeichnis/%s", city, letter);
            URL u = new URL(url);
            BufferedReader in = new BufferedReader(new InputStreamReader(u.openStream(), "UTF-8"));
            boolean startWorking = false;
            int before = streets.size();
            while ((s = in.readLine()) != null) {
                if (i == 97 && s.indexOf("node_plz=") != -1) {
                    int index = s.indexOf("node_plz=") + 10;
                    plz = s.substring(index, index + 5);
                    continue;
                }
                if (s.indexOf("Stra\u00dfennamen:") != -1) {
                    startWorking = true;
                    continue;
                }
                if (!startWorking) continue;
                if (s.trim().endsWith("</a></li>")) {
                    streets.add(s.replaceAll("</a></li>", "").trim());
                    continue;
                }
                if (s.indexOf("<div id=\"mt-content-ri\">") == -1) continue;
            }
            in.close();
            before = streets.size() - before;
            System.out.println(String.format("Anzahl gefundener Stra\u00dfen f\u00fcr Buchstaben %s: %d", letter, before));
            ++i;
        }
        System.out.println(String.format("Anzahl gefundene Stra\u00dfen: %d", streets.size()));
        return streets;
    }
}

