/*
 * Decompiled with CFR 0.152.
 */
package fmeListener;

import fmeListener.FMEListener;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortListener
implements Runnable,
SerialPortEventListener {
    private CommPortIdentifier serialPortId;
    private Enumeration enumComm;
    private SerialPort serialPort;
    private InputStream inputStream;
    private boolean serialPortGeoeffnet = false;
    private StringBuffer data;
    private TimeWatcher tw;
    private final FMEListener fmeListener;
    private boolean isFree = true;
    private final int dataBits = 8;
    private final int stopBits = 1;
    private final int parity = 0;
    private int waitTime = 1000;
    private final Logger logger;

    public PortListener(FMEListener fmeListener, int waitTime) {
        this.fmeListener = fmeListener;
        this.waitTime = waitTime;
        this.logger = LoggerFactory.getLogger((String)"DME-Listener");
    }

    @Override
    public void run() {
        this.logger.debug("Starte Abh\u00f6ren des Ports...");
        while (true) {
            try {
                while (true) {
                    Thread.sleep(20000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public boolean openSerialPort(String portName, int baudrate) {
        boolean foundPort = false;
        if (this.serialPortGeoeffnet) {
            this.logger.debug("Serialport bereits ge\u00f6ffnet");
            return false;
        }
        this.logger.info("Liste verf\u00fcgbare Ports auf und \u00f6ffne Serialport '" + portName + "'...");
        this.enumComm = CommPortIdentifier.getPortIdentifiers();
        int i = 0;
        while (this.enumComm.hasMoreElements()) {
            ++i;
            this.serialPortId = (CommPortIdentifier)this.enumComm.nextElement();
            this.logger.info("Port: " + this.serialPortId.getName() + "(Typ: " + this.serialPortId.getPortType() + ")");
            if (!portName.contentEquals(this.serialPortId.getName())) continue;
            foundPort = true;
            this.logger.info("Port gefunden");
            break;
        }
        this.logger.info("Anzahl gefundener Ports: " + i);
        if (i == 0) {
            this.logger.error("Kein Serialport wurde gefunden. Stellen Sie sicher, dass Sie alle ben\u00f6tigten externen Dateien richtig installiert haben!");
        }
        if (!foundPort) {
            this.logger.error("Serialport nicht gefunden: " + portName);
            return false;
        }
        try {
            this.serialPort = (SerialPort)this.serialPortId.open("\u00d6ffnen und Senden", 500);
        }
        catch (PortInUseException e) {
            this.logger.error("Port bereits belegt", (Throwable)e);
            return false;
        }
        try {
            this.inputStream = this.serialPort.getInputStream();
            this.logger.debug("Zugriff auf InputStream");
        }
        catch (IOException e) {
            this.logger.error("Keinen Zugriff auf InputStream", (Throwable)e);
            return false;
        }
        try {
            this.serialPort.addEventListener((SerialPortEventListener)this);
            this.logger.debug("EventListener hinzugef\u00fcgt");
        }
        catch (TooManyListenersException e) {
            this.logger.error("Listener konnte nicht hinzugef\u00fcgt werden", (Throwable)e);
            return false;
        }
        this.serialPort.notifyOnDataAvailable(true);
        try {
            this.serialPort.setSerialPortParams(baudrate, 8, 1, 0);
            this.logger.debug("Setzte Parameter: ");
            this.logger.debug("Baudrate: \t" + baudrate);
            this.logger.debug("dataBits: \t8");
            this.logger.debug("stopBits: \t1");
            this.logger.debug("parity: \t0");
        }
        catch (UnsupportedCommOperationException e) {
            this.logger.error("Konnte Schnittstellen-Paramter nicht setzen.", (Throwable)e);
            this.serialPort.close();
            return false;
        }
        this.serialPortGeoeffnet = true;
        this.logger.info("Serialport erfolgreich ge\u00f6ffnet");
        return true;
    }

    public void closeSerialPort() {
        if (this.serialPortGeoeffnet) {
            this.logger.debug("Schlie\u00dfe Serialport...");
            this.serialPort.close();
            this.serialPortGeoeffnet = false;
        } else {
            this.logger.warn("Serialport bereits geschlossen");
        }
    }

    private void serialPortDatenVerfuegbar() {
        if (this.isFree) {
            this.tw = new TimeWatcher();
            this.tw.start();
        }
        if (this.data == null) {
            this.data = new StringBuffer();
        }
        try {
            byte[] byteData = new byte[150];
            while (this.inputStream.available() > 0) {
                int num = this.inputStream.read(byteData, 0, byteData.length);
                String tmp = new String(byteData, 0, num);
                this.data.append(tmp);
                this.logger.debug("Read: " + tmp + " - " + Arrays.toString(byteData));
            }
        }
        catch (IOException e) {
            this.logger.error("Fehler beim Lesen empfangener Daten.", (Throwable)e);
        }
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 1: {
                this.serialPortDatenVerfuegbar();
                break;
            }
            case 10: {
                break;
            }
            case 6: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 9: {
                break;
            }
            case 2: {
                break;
            }
            case 8: {
                break;
            }
        }
    }

    class TimeWatcher
    extends Thread {
        public TimeWatcher() {
            PortListener.this.isFree = false;
        }

        @Override
        public void run() {
            PortListener.this.logger.debug("Warte auf Nachricht: " + PortListener.this.waitTime + " ms");
            try {
                try {
                    Thread.sleep(PortListener.this.waitTime);
                }
                catch (Exception e) {
                    PortListener.this.logger.error("Fehler beim Warten", (Throwable)e);
                    PortListener.this.logger.debug("Warten beendet. Setze Text: " + PortListener.this.data.toString());
                    PortListener.this.fmeListener.setAlarm(PortListener.this.data.toString());
                    PortListener.this.isFree = true;
                    PortListener.this.data = null;
                }
            }
            finally {
                PortListener.this.logger.debug("Warten beendet. Setze Text: " + PortListener.this.data.toString());
                PortListener.this.fmeListener.setAlarm(PortListener.this.data.toString());
                PortListener.this.isFree = true;
                PortListener.this.data = null;
            }
        }
    }
}

