/*
 * Decompiled with CFR 0.152.
 */
package fmeListener;

import fmeListener.PortListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.slf4j.LoggerFactory;
import server.AlarmData;
import server.IAlarmPool;
import server.guielements.Checkbox;
import server.guielements.GUIElement;
import server.guielements.Text;
import server.guielements.Textarea;
import server.input.AbstractInput;

public class FMEListener
extends AbstractInput {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> userMap = new HashMap<String, String>();
    private final List<String> defaultUser = new ArrayList<String>();
    private String comName = "COM1";
    private int baudrate = 9600;
    private int waitTime = 600;
    private transient PortListener listener;
    private boolean activ = false;
    private boolean isSwissphone = false;

    public FMEListener(IAlarmPool alarmPool) {
        super(alarmPool);
        this.setName("DME-Input");
    }

    public FMEListener(IAlarmPool alarmPool, int port) {
        super(alarmPool);
        this.setName("DME-Input");
    }

    public void run() {
        this.logger = LoggerFactory.getLogger((String)"DME-Listener");
        if (!this.activ) {
            return;
        }
        if (this.isSwissphone) {
            this.logger.debug("NUL wird als neuer Alarm interpretiert");
        }
        this.listener = new PortListener(this, this.waitTime);
        boolean success = this.listener.openSerialPort(this.comName, this.baudrate);
        if (success) {
            new Thread(this.listener).start();
        }
    }

    public void setAlarm(String input) {
        ArrayList<String> alarmTexts = new ArrayList<String>();
        if (this.isSwissphone) {
            String[] arr;
            String[] stringArray = arr = input.split("\u0000");
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!(s = s.trim()).equals("")) {
                    alarmTexts.add(s);
                }
                ++n2;
            }
        } else {
            alarmTexts.add(input);
        }
        this.logger.info("Anzahl Alarmtexte: " + alarmTexts.size());
        for (String s : alarmTexts) {
            StringBuffer tp = new StringBuffer();
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if ((c >= ' ' && c <= '}' || c >= '\u00c0' && c <= '\u00ff') && c != '\n') {
                    tp.append(s.charAt(i));
                }
                ++i;
            }
            String alarmText = tp.toString();
            this.logger.info("Alarmtext: " + alarmText);
            ArrayList<String> toAlarm = new ArrayList<String>();
            for (String code : this.userMap.keySet()) {
                if (alarmText.indexOf(code) == -1) continue;
                this.logger.info("\u00dcbereinstimmung gefunden: " + code);
                toAlarm.add(this.userMap.get(code));
            }
            if (toAlarm.size() == 0) {
                this.logger.warn("Keine \u00dcbereinstimmung gefunden. Nutze Standard-Einheiten");
                toAlarm.addAll(this.defaultUser);
            }
            Date date = new Date();
            for (String user : toAlarm) {
                this.logger.debug("Alarm ausgel\u00f6st f\u00fcr: " + user);
                this.sendAlarmData(new AlarmData(this.parseAlarm(alarmText, user, date), date));
            }
        }
    }

    public String toString() {
        return "DME-Empf\u00e4nger";
    }

    public String getAuthor() {
        return "firEmergency";
    }

    public String getCurrentVersion() {
        return "1.5";
    }

    public String getDescription() {
        return "Empf\u00e4ngt den Text eines via serielle Schnittstelle angeschlossenen DME`s.";
    }

    public ImageIcon getIcon16() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/fmeListener/logo-16.png"));
    }

    public ImageIcon getIcon48() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/fmeListener/logo-48.png"));
    }

    public Hashtable<String, String> parseAlarm(String message, String code, Date date) {
        Hashtable<String, String> tab = new Hashtable<String, String>();
        tab.put("address", code);
        tab.put("timestamp", String.valueOf(date.getTime()));
        tab.put("message", message);
        return tab;
    }

    public void sendAlarmData(AlarmData arg0) {
        this.alarmPool.addAlarmData(arg0);
    }

    public void buildGUI() {
        Checkbox element = new Checkbox("Aktivieren", "Schaltet den DME-Listener aktiv", 0);
        element.setValue((Object)false);
        this.inputData.put("activ", element);
        element = new Text("Dauer des Alarms in ms", "So lange soll der Text gesammelt werden. Standard 600 Milisekunden", 1);
        element.setValue((Object)"600");
        this.inputData.put("waitTime", element);
        element = new Text("Port", "Der Port, der abgeh\u00f6rt werden soll (COM1, COM2, ...)", 2);
        element.setValue((Object)"COM1");
        this.inputData.put("port", element);
        element = new Text("Baudrate", "Die verwendete Baudrate", 3);
        element.setValue((Object)"9600");
        this.inputData.put("baud", element);
        element = new Checkbox("NUL als neuen Alarm interpretieren", "Mehrere Nachrichten,  welche durch NUL getrennt werden, werden als eigene Alarmierungen interpretiert", 4);
        element.setValue((Object)false);
        this.inputData.put("swissphone", element);
        element = new Textarea("Standard-Codes", "Sollte kein Stichwort gefunden werden, so wird die Standardeinheit(en) alarmiert.", 5);
        this.inputData.put("default", element);
        element = new Textarea("Codes der zu alarmierenden Einheiten", "Geben Sie hier die Einheitencodes an. Bitte die Anleitung beachten.", 6);
        this.inputData.put("codes", element);
    }

    public void setNewParameters() {
        String code;
        this.logger = LoggerFactory.getLogger((String)"FMEListener");
        try {
            if (this.inputData.get("waitTime") != null) {
                this.waitTime = Integer.parseInt((String)((GUIElement)this.inputData.get("waitTime")).getValue());
            }
        }
        catch (NumberFormatException e) {
            this.logger.error("Falsches Zeitformat-Format: " + ((GUIElement)this.inputData.get("waitTime")).getValue());
        }
        try {
            this.baudrate = Integer.parseInt((String)((GUIElement)this.inputData.get("baud")).getValue());
        }
        catch (NumberFormatException e) {
            this.logger.error("Ung\u00fcltige Baudrate: " + ((GUIElement)this.inputData.get("baud")).getValue());
        }
        this.comName = (String)((GUIElement)this.inputData.get("port")).getValue();
        this.activ = (Boolean)((GUIElement)this.inputData.get("activ")).getValue();
        this.isSwissphone = this.inputData.containsKey("swissphone") ? (Boolean)((GUIElement)this.inputData.get("swissphone")).getValue() : false;
        if (((GUIElement)this.inputData.get("codes")).getValue() == null) {
            return;
        }
        String[] lines = ((String)((GUIElement)this.inputData.get("codes")).getValue()).split("\\r?\\n");
        this.userMap.clear();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] arr;
            code = stringArray[n2];
            if (code != null && !code.equals("") && (arr = (code = code.trim()).split(";")) != null) {
                if (arr.length != 2) {
                    this.logger.warn("Ung\u00fcltige Zeile: " + code);
                } else {
                    this.userMap.put(arr[0], arr[1]);
                }
            }
            ++n2;
        }
        this.defaultUser.clear();
        if (((GUIElement)this.inputData.get("default")).getValue() == null) {
            return;
        }
        stringArray = lines = ((String)((GUIElement)this.inputData.get("default")).getValue()).split("\\r?\\n");
        n = lines.length;
        n2 = 0;
        while (n2 < n) {
            code = stringArray[n2];
            this.defaultUser.add(code.trim());
            ++n2;
        }
    }

    public void stopInput() {
        if (this.listener != null) {
            this.listener.closeSerialPort();
        }
    }
}

