/*
 * Decompiled with CFR 0.152.
 */
package mailInput;

import java.io.IOException;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import javax.mail.internet.MimeMessage;

class MailClient
extends Authenticator
implements MessageCountListener {
    public static final int SHOW_MESSAGES = 1;
    public static final int CLEAR_MESSAGES = 2;
    public static final int SHOW_AND_CLEAR = 3;
    protected String from;
    protected Session session;
    protected PasswordAuthentication authentication;

    public MailClient(String user, String pw, String host) {
        this(user, pw, host, false);
    }

    public MailClient(String user, String password, String host, boolean debug) {
        this.from = String.valueOf(user) + '@' + host;
        this.authentication = new PasswordAuthentication(user, password);
        Properties props = new Properties();
        props.put("mail.user", user);
        props.put("mail.host", host);
        props.put("mail.debug", debug ? "true" : "false");
        props.put("mail.store.protocol", "pop3");
        props.put("mail.transport.protocol", "imap");
        this.session = Session.getInstance((Properties)props, (Authenticator)this);
        try {
            Store store = this.session.getStore();
            store.connect();
            Folder root = store.getDefaultFolder();
            Folder inbox = root.getFolder("inbox");
            inbox.addMessageCountListener((MessageCountListener)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PasswordAuthentication getPasswordAuthentication() {
        return this.authentication;
    }

    public void sendMessage(String to, String subject, String content) throws MessagingException {
        System.out.println("SENDING message from " + this.from + " to " + to);
        System.out.println();
        MimeMessage msg = new MimeMessage(this.session);
        msg.addRecipients(Message.RecipientType.TO, to);
        msg.setSubject(subject);
        msg.setText(content);
        Transport.send((Message)msg);
    }

    public void checkInbox(int mode) throws MessagingException, IOException {
        if (mode == 0) {
            return;
        }
        boolean show = (mode & 1) > 0;
        boolean clear = (mode & 2) > 0;
        String action = String.valueOf(show ? "Show" : "") + (show && clear ? " and " : "") + (clear ? "Clear" : "");
        System.out.println(String.valueOf(action) + " INBOX for " + this.from);
        Store store = this.session.getStore();
        store.connect();
        Folder root = store.getDefaultFolder();
        Folder inbox = root.getFolder("inbox");
        inbox.open(2);
        Message[] msgs = inbox.getMessages();
        if (msgs.length == 0 && show) {
            System.out.println("No messages in inbox");
        }
        int i = 0;
        while (i < msgs.length) {
            MimeMessage msg = (MimeMessage)msgs[i];
            if (show) {
                System.out.println("    From: " + msg.getFrom()[0]);
                System.out.println(" Subject: " + msg.getSubject());
                System.out.println(" Content: " + msg.getContent());
            }
            if (clear) {
                msg.setFlag(Flags.Flag.DELETED, true);
            }
            ++i;
        }
        inbox.close(true);
        store.close();
        System.out.println();
    }

    public void messagesAdded(MessageCountEvent arg0) {
        System.err.println("New Message");
    }

    public void messagesRemoved(MessageCountEvent arg0) {
        System.err.println("Message deleted");
    }
}

