/*
 * Decompiled with CFR 0.152.
 */
package apager;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import server.AlarmData;

public class SendMessage {
    private static final Logger logger = Logger.getLogger((String)"SendMessage");

    public static void toRecepient(AlarmData ad, String group, List<String> emails) {
        Gson g = new Gson();
        HashMap<String, String> tmp = new HashMap<String, String>();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < emails.size()) {
            buf.append(emails.get(i).trim());
            if (i != emails.size() - 1) {
                buf.append(";");
            }
            ++i;
        }
        tmp.put("e", buf.toString());
        try {
            tmp.put("g", URLEncoder.encode(group, "UTF-8"));
        }
        catch (UnsupportedEncodingException e3) {
            tmp.put("g", group);
        }
        tmp.put("t", "" + ad.getFormattedTime());
        if (!ad.getParameter("id").equals("")) {
            tmp.put("id", ad.getParameter("id"));
        }
        try {
            tmp.put("m", URLEncoder.encode(ad.getPluginMessage(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e3) {
            tmp.put("m", ad.getPluginMessage());
        }
        if (!ad.getParameter("location_dest").equals("")) {
            try {
                tmp.put("l", URLEncoder.encode(ad.getParameter("location_dest"), "UTF-8"));
            }
            catch (UnsupportedEncodingException e3) {
                tmp.put("l", ad.getParameter("location_dest"));
            }
        }
        if (!ad.getParameter("feedback_overview").equals("")) {
            tmp.put("fo", ad.getParameter("feedback_overview"));
        }
        if (!ad.getParameter("lat").equals("") && !ad.getParameter("lng").equals("")) {
            tmp.put("la", ad.getParameter("lat"));
            tmp.put("ln", ad.getParameter("lng"));
        }
        String json = g.toJson(tmp);
        logger.debug((Object)("JSON: " + json));
        try {
            json = URLEncoder.encode(json, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            logger.warn((Object)"Nachricht konnte nicht korrekt encodiert werden", (Throwable)e1);
        }
        logger.info((Object)("Gr\u00f6\u00dfe der Nachricht: " + json.getBytes().length));
        try {
            String line;
            URL url = new URL("https://apager-firemergency-2.appspot.com/gcm2");
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(json);
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            buf = new StringBuffer();
            while ((line = rd.readLine()) != null) {
                buf.append(line);
            }
            if (buf.toString().equals("OK")) {
                logger.info((Object)"Nachricht erfolgreich versandt");
            } else {
                logger.error((Object)("Versand fehlgeschlagen: " + buf.toString()));
                ad.addPluginError("Android", "Versand fehlgeschlagen: " + buf.toString());
            }
            wr.close();
            rd.close();
        }
        catch (IOException e) {
            logger.error((Object)("Versand fehlgeschlagen: " + e.getLocalizedMessage()), (Throwable)e);
            ad.addPluginError("Android", "Versand fehlgeschlagen: " + e.getLocalizedMessage());
        }
    }
}

