/*
 * Decompiled with CFR 0.152.
 */
package apager;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import server.AlarmData;

public class AndroidTest {
    private static final boolean local = false;

    public static void main(String[] args) throws Exception {
        Hashtable<String, String> dict = new Hashtable<String, String>();
        ((Dictionary)dict).put("timestamp", String.valueOf(System.currentTimeMillis()));
        ((Dictionary)dict).put("message", "Dies M\u00c4HHHH ist eine Testnachricht mit Umlauten: \u00f6\u00e4\u00fc?\u00df\u00d6\u00c4\u00dc\n und zeilenumbr\u00fcchen");
        ((Dictionary)dict).put("id", "TestAlarm2");
        ((Dictionary)dict).put("location_dest", "Ringstra\u00dfe 19, Unterglauheim");
        AlarmData ad = new AlarmData(dict, new Date());
        ArrayList<String> dest = new ArrayList<String>();
        dest.add("hodenkobold63@gmail.com");
        AndroidTest.toRecepient(ad, "TestAlarm", dest);
    }

    public static void response(String id) throws Exception {
        String line;
        URL url = new URL(String.format("https://apager-firemergency-2.appspot.com/gcm2?id=%s", id));
        System.out.println(url);
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
        }
        System.out.println("done");
    }

    public static void register(String email, String token) {
        Gson g = new Gson();
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put("email", email);
        tmp.put("token", token);
        String json = g.toJson(tmp);
        System.out.println("JSON: " + json);
        System.out.println("Gr\u00f6\u00dfe der Nachricht: " + json.getBytes().length);
        try {
            System.out.println("Sende Nachricht an Server...");
            json = URLEncoder.encode(json, "UTF-8");
            System.out.println(json);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        System.out.println("Gr\u00f6\u00dfe der Nachricht: " + json.getBytes().length);
        try {
            String line;
            URL url = new URL("https://apager-firemergency-2.appspot.com/gcm2");
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(json);
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuffer buf = new StringBuffer();
            while ((line = rd.readLine()) != null) {
                buf.append(line);
            }
            if (buf.toString().equals("OK")) {
                System.out.println("Nachricht erfolgreich versandt");
            } else {
                System.err.println("Versand fehlgeschlagen: " + buf.toString());
            }
            wr.close();
            rd.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void toRecepient(AlarmData ad, String group, List<String> emails) {
        Gson g = new Gson();
        HashMap<String, String> tmp = new HashMap<String, String>();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < emails.size()) {
            buf.append(emails.get(i).trim());
            if (i != emails.size() - 1) {
                buf.append(";");
            }
            ++i;
        }
        tmp.put("e", buf.toString());
        try {
            tmp.put("g", URLEncoder.encode(group, "UTF-8"));
        }
        catch (UnsupportedEncodingException e3) {
            tmp.put("g", group);
        }
        tmp.put("t", "" + ad.getFormattedTime());
        if (!ad.getParameter("id").equals("")) {
            tmp.put("id", ad.getParameter("id"));
        }
        try {
            tmp.put("m", URLEncoder.encode(ad.getPluginMessage(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e3) {
            tmp.put("m", ad.getPluginMessage());
        }
        if (!ad.getParameter("location_dest").equals("")) {
            try {
                tmp.put("l", URLEncoder.encode(ad.getParameter("location_dest"), "UTF-8"));
            }
            catch (UnsupportedEncodingException e3) {
                tmp.put("l", ad.getParameter("location_dest"));
            }
        }
        if (!ad.getParameter("lat").equals("") && !ad.getParameter("lng").equals("")) {
            tmp.put("la", ad.getParameter("lat"));
            tmp.put("ln", ad.getParameter("lng"));
        }
        String json = g.toJson(tmp);
        System.out.println("JSON: " + json);
        System.out.println("Gr\u00f6\u00dfe der Nachricht: " + json.getBytes().length);
        try {
            System.out.println("Sende Nachricht an Server...");
            json = URLEncoder.encode(json, "UTF-8");
            System.out.println(json);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        System.out.println("Gr\u00f6\u00dfe der Nachricht: " + json.getBytes().length);
        try {
            String line;
            URL url = new URL("https://apager-firemergency-2.appspot.com/gcm2");
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(json);
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            buf = new StringBuffer();
            while ((line = rd.readLine()) != null) {
                buf.append(line);
            }
            if (buf.toString().equals("OK")) {
                System.out.println("Nachricht erfolgreich versandt");
            } else {
                System.err.println("Versand fehlgeschlagen: " + buf.toString());
                ad.addPluginError("Android", "Versand fehlgeschlagen: " + buf.toString());
            }
            wr.close();
            rd.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            ad.addPluginError("Android", "Versand fehlgeschlagen: " + e.getLocalizedMessage());
        }
    }
}

