/*
 * Decompiled with CFR 0.152.
 */
package android;

import android.SendMessage;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import server.AbstractPlugin;
import server.AlarmData;
import server.guielements.Checkbox;
import server.guielements.GUIElement;
import server.guielements.Label;
import server.guielements.PersonSelectBox;
import server.guielements.Text;

public class Android
extends AbstractPlugin {
    private static final long serialVersionUID = 1719705404410478163L;

    public Android() {
        this.pluginData.put("description", new Label("Mit diesem Plugin k\u00f6nnen Push-Notifikationen an Ihr Android-Ger\u00e4t schicken.<br/> Dazu ben\u00f6tigen Sie die App <b>aPager</b>", "", 0));
        this.pluginData.put("absender", new Text("Einheitenkennung (optional)", "Diese Bezeichnung wird in der App als Absender angezeigt.", 1));
        this.pluginData.put("sms", new Checkbox("F\u00fcr SMS-Versand vorbereiten", "Bereitet die Nachricht f\u00fcr einen sp\u00e4teren SMS vor", 2));
        this.pluginData.put("gmail", new PersonSelectBox("Personen", "Gmail Accounts", 3, "gmail"));
    }

    public AlarmData run(AlarmData ad) throws Exception {
        String tmp;
        Object o;
        assert (ad != null);
        this.logger = Logger.getLogger(((Object)((Object)this)).getClass());
        this.logger.debug((Object)("Alarm: " + ad.getPluginMessage()));
        String message = ad.getPluginMessage();
        String group = null;
        if (this.pluginData.containsKey("absender") && (o = ((GUIElement)this.pluginData.get("absender")).getValue()) != null && !(tmp = (String)o).equals("")) {
            group = tmp;
        }
        if (group == null) {
            group = ad.getAddress();
            if (!ad.getParameter("longdescription").equals("")) {
                group = ad.getParameter("longdescription");
            } else if (!ad.getParameter("description").equals("")) {
                group = ad.getParameter("description");
            }
        }
        SendMessage sender = new SendMessage(message, group);
        if (this.personsToAlarm.get("gmail") == null || ((List)this.personsToAlarm.get("gmail")).size() == 0) {
            this.logger.warn((Object)"Android Liste enth\u00e4lt keine Eintr\u00e4ge >> Niemand kann alarmiert werden");
        } else {
            for (String person : (List)this.personsToAlarm.get("gmail")) {
                if (person == null || person.trim().equals("")) continue;
                person = person.trim();
                this.logger.debug((Object)("Sende Alarm an: " + person));
                try {
                    sender.toRecepient(person, ad);
                }
                catch (Exception e) {
                    ad.addPluginError("Android", "Fehler beim Versand an " + person + " aufgetreten. (" + e.getMessage() + ")");
                }
            }
        }
        if (this.pluginData.get("sms") != null && ((Boolean)((GUIElement)this.pluginData.get("sms")).getValue()).booleanValue()) {
            StringBuffer buf = new StringBuffer("apgr{");
            buf.append(String.format("\"g\":\"%s\",", group));
            buf.append(String.format("\"m\":\"%s\"", message));
            if (!ad.getParameter("lat").equals("")) {
                buf.append(String.format(",\"la\":\"%s\"", ad.getParameter("lat")));
            }
            if (!ad.getParameter("lng").equals("")) {
                buf.append(String.format(",\"ln\":\"%s\"", ad.getParameter("lng")));
            }
            if (!ad.getParameter("location_dest").equals("")) {
                buf.append(String.format(",\"l\":\"%s\"", ad.getParameter("location_dest")));
            }
            buf.append("}");
            this.logger.debug((Object)("Nachricht f\u00fcr SMS gesetzt: " + buf.toString()));
            ad.setPluginMessage(buf.toString());
        }
        return ad;
    }

    public int getTimeOut() {
        return 60000;
    }

    public String getDescription() {
        return "Erm\u00f6glicht das Versenden von Push Benachrichtigungen an Android Telefone.";
    }

    public String getCurrentVersion() {
        return "1.8";
    }

    public String getAuthor() {
        return "firEmergency";
    }

    public ImageIcon getIcon16() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/android/android-16.png"));
    }

    public ImageIcon getIcon48() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/android/android-48.png"));
    }

    public String toString() {
        return "Android";
    }
}

