/*
 * Decompiled with CFR 0.152.
 */
package android;

import android.org.json.JSONException;
import android.org.json.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import server.AlarmData;
import server.feedback.FeedbackUtils;

public class SendMessage {
    private static final String server = "https://apager-server.appspot.com/alarm";
    private static final String[] filters = new String[]{"status", "subric", "location_URL", "keyword", "keyword_description", "pluginmessage", "message"};
    private final String message;
    private final String group;
    private final Logger logger = Logger.getLogger(this.getClass());
    private final boolean success = false;

    public SendMessage(String message, String group) {
        this.group = group;
        this.message = message;
    }

    public void toRecepient(String email, AlarmData alarmData) throws Exception {
        try {
            String line;
            StringBuffer buf = new StringBuffer();
            buf.append(String.valueOf(URLEncoder.encode("email", "UTF-8")) + "=" + URLEncoder.encode(email, "UTF-8"));
            buf.append("&" + URLEncoder.encode("message", "UTF-8") + "=" + URLEncoder.encode(this.message, "UTF-8"));
            buf.append("&" + URLEncoder.encode("group", "UTF-8") + "=" + URLEncoder.encode(this.group, "UTF-8"));
            Enumeration keys = alarmData.getAllKeys();
            buf.append("&extra={");
            boolean firstOne = true;
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                boolean ignore = false;
                String[] stringArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    String filter = stringArray[n2];
                    if (key.equals(filter)) {
                        ignore = true;
                        break;
                    }
                    ++n2;
                }
                if (ignore) continue;
                if (firstOne) {
                    firstOne = false;
                } else {
                    buf.append(",");
                }
                if (key.equals("location_dest")) {
                    buf.append("\"" + URLEncoder.encode("location", "UTF-8") + "\"");
                } else {
                    buf.append("\"" + URLEncoder.encode(key, "UTF-8") + "\"");
                }
                buf.append(":");
                buf.append("\"" + URLEncoder.encode(alarmData.getParameter(key), "UTF-8") + "\"");
            }
            buf.append(",");
            buf.append("\"" + URLEncoder.encode("userName", "UTF-8") + "\"");
            buf.append(":");
            buf.append("\"" + URLEncoder.encode(FeedbackUtils.getNameForAddress((String)email), "UTF-8") + "\"");
            buf.append("}");
            this.logger.debug((Object)"Send To: https://apager-server.appspot.com/alarm");
            URL url = new URL(server);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            this.logger.debug((Object)("Send Data: " + buf.toString()));
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(buf.toString());
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                sb.append(line);
            }
            String returnMessage = sb.toString();
            this.logger.debug((Object)returnMessage);
            wr.close();
            rd.close();
            try {
                JSONObject jsonObject = new JSONObject(returnMessage);
                String status = (String)jsonObject.get("status");
                String c2dmRespnonse = jsonObject.getString("c2dm_response");
                this.logger.debug((Object)("Status der Server Antwort: " + status));
                this.logger.debug((Object)("Antwort von C2DM Service: " + c2dmRespnonse));
                if (!status.contains("Succesfully sent")) {
                    this.logger.error((Object)("Fehler beim senden GAE Fehler: " + status));
                    throw new IOException("Fehler beim senden GAE Fehler: " + status);
                }
                if (c2dmRespnonse.startsWith("Error")) {
                    this.logger.error((Object)("Fehler beim senden C2DM Fehler: " + c2dmRespnonse));
                    throw new IOException("Fehler beim senden C2DM Fehler: " + c2dmRespnonse);
                }
            }
            catch (JSONException e) {
                this.logger.error((Object)"Antwort vom Server nicht verstanden.", (Throwable)e);
                throw e;
            }
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error((Object)"Fehler beim Codieren der Nachricht", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.logger.error((Object)"URL konnte nicht generiert werden", (Throwable)e);
            throw e;
        }
    }
}

