/*
 * Decompiled with CFR 0.152.
 */
package monitor;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import server.AbstractPlugin;
import server.AlarmData;
import server.guielements.GUIElement;
import server.guielements.Label;
import server.guielements.Text;

public class Monitor
extends AbstractPlugin {
    private static final long serialVersionUID = 1L;

    public Monitor() {
        this.pluginData.put("description", new Label("Mit diesem Plugin ist es m\u00f6glich den AlarmMonitor direkt ansprechen zu k\u00f6nnen.<br/> Informationen dazu: www.alarmtool.de", "", 0));
        this.pluginData.put("ip", new Text("IP", "Die IP des AlarmMonitors (falls lokal: 127.0.0.1)", 1));
        this.pluginData.put("port", new Text("Port", "Der Port des AlarmMonitors (Standard: 7777)", 2));
    }

    public AlarmData run(AlarmData ad) throws Exception {
        int port;
        char[] arr;
        this.logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
        this.logger.info((Object)"AlarmMonitor Plugin gestartet");
        ArrayList<String> temp = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        String text = ad.getPluginMessage();
        char[] cArray = arr = text.toCharArray();
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            if (element == '\n') {
                temp.add(buf.toString());
                buf = new StringBuffer();
            } else if (element != '\r') {
                buf.append(element);
            }
            ++n2;
        }
        if (buf.length() != 0) {
            temp.add(buf.toString());
        }
        String host = (String)((GUIElement)this.pluginData.get("ip")).getValue();
        String portTmp = (String)((GUIElement)this.pluginData.get("port")).getValue();
        try {
            port = Integer.parseInt(portTmp);
        }
        catch (NumberFormatException e) {
            ad.addPluginError("AlarmMonitor", "Ung\u00fclter Port: " + portTmp);
            return ad;
        }
        Socket echoSocket = null;
        BufferedWriter bufWr = null;
        try {
            echoSocket = new Socket(host, port);
            this.logger.info((Object)("Verbunden mit Monitor  " + echoSocket.getInetAddress() + " an Port " + echoSocket.getPort()));
            bufWr = new BufferedWriter(new OutputStreamWriter(echoSocket.getOutputStream(), "UTF-8"));
        }
        catch (Exception e) {
            ad.addPluginError("AlarmMonitor", "Verbindung mit Monitor: " + host + " fehlgeschlagen - " + e.getMessage());
            this.logger.error((Object)("Verbindung mit Monitor fehlgeschlagen" + host), (Throwable)e);
            return ad;
        }
        if (echoSocket != null && bufWr != null) {
            try {
                for (String s : temp) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Schicke Zeile: " + s));
                    }
                    bufWr.write(s);
                    bufWr.newLine();
                    bufWr.flush();
                }
                bufWr.close();
                echoSocket.close();
            }
            catch (Exception e) {
                ad.addPluginError("AlarmMonitor", "Verbindung mit Monitor: " + host + " - " + e.getMessage());
                this.logger.error((Object)("Verbindung mit Monitor: Host nicht gefunden: " + host), (Throwable)e);
                return ad;
            }
        }
        this.logger.info((Object)"AlarmMonitor Plugin beendet");
        return ad;
    }

    public int getTimeOut() {
        return 60000;
    }

    public String getDescription() {
        return "Weitergabe an den AlarmMonitor";
    }

    public String getCurrentVersion() {
        return "1.0";
    }

    public String getAuthor() {
        return "firEmergency";
    }

    public ImageIcon getIcon48() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/monitor/logo-48.png"));
    }

    public ImageIcon getIcon16() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/monitor/logo-16.png"));
    }

    public String toString() {
        return "AlarmMonitor";
    }
}

