/*
 * Decompiled with CFR 0.152.
 */
package textmod;

import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import server.AbstractPlugin;
import server.AlarmData;
import server.guielements.Checkbox;
import server.guielements.GUIElement;
import server.guielements.Label;
import server.guielements.Textarea;

public class Textmod
extends AbstractPlugin {
    private static final long serialVersionUID = 1L;

    public Textmod() {
        this.pluginData.put("declaration1", new Label("Jede Ersetzungregel in eine Zeile.<br>Das zu suchende Wort und das zu ersetzende Wort durch <b>;</b> trennen.<br><br>Falls das Zeichen <b>;</b> oder <b>\\</b> in eine Ersetzungregel integriert werden soll,<br> muss diesem das Zeichen <b>\\</b> voran gestellt werden<br>Beispiel: <br><ul><li>H\u00f6he\\;Breite;H\u00f6he_Breite ersetzt H\u00f6he\\;Breite durch H\u00f6he_Breite</li><li>C:\\\\dir123;C:\\\\dir456 ersetzt C:\\dir123 durch C:\\dir456</li></ul><br>Falls ein Wort gel\u00f6scht werden soll, Eintrag nach <b>;</b> leer lassen<br><br>Regeln werden auch auf den Betreff angewendet", "", 0));
        this.pluginData.put("replaceArea", new Textarea("Ersetzungsregeln", "Je eine Regel pro Zeile. Wort das zu ersetzen ist und das Wort das eingesetzt werden soll durch ';' trennen. Zum l\u00f6schen kein weiteres Wort nach ; eintragen", 3));
        this.pluginData.put("regex", new Checkbox("Regul\u00e4re Ausdr\u00fccke", "Ob regul\u00e4re Ausdr\u00fccke verwendet werden sollen oder nicht", 3));
        this.pluginData.put("clean", new Checkbox("Text sinnvoll k\u00fcrzen", "Ob gleiche, nacheinander folgende W\u00f6rter gel\u00f6scht werden", 4));
    }

    public AlarmData run(AlarmData ad) throws Exception {
        int errorcounter = 1;
        this.logger = Logger.getLogger(((Object)((Object)this)).getClass());
        this.logger.debug((Object)"Textmodplugin gestartet");
        String replaceRules = (String)((GUIElement)this.pluginData.get("replaceArea")).getValue();
        boolean regex = false;
        if (((GUIElement)this.pluginData.get("regex")).getValue() != null) {
            regex = (Boolean)((GUIElement)this.pluginData.get("regex")).getValue();
        }
        String aText = ad.getPluginMessage();
        String aSubject = ad.getSubject();
        if (regex) {
            this.logger.debug((Object)"Interpretiere Regel als regul\u00e4ren Ausdruck");
        }
        if (replaceRules == null || replaceRules.equals("")) {
            this.logger.debug((Object)"Keine Regeln konfiguriert!");
        } else {
            String[] replaceRulesSplit;
            this.logger.debug((Object)("Alarmtext: " + aText));
            this.logger.debug((Object)("Betreff: " + aSubject));
            String[] stringArray = replaceRulesSplit = replaceRules.split("[\\r\\n]+");
            int n = replaceRulesSplit.length;
            int n2 = 0;
            while (n2 < n) {
                String replaceRule = stringArray[n2];
                try {
                    this.logger.trace((Object)("ReplaceRule: " + replaceRule));
                    int semindex = replaceRule.indexOf(";");
                    while (semindex > 0 && replaceRule.charAt(semindex - 1) == '\\') {
                        try {
                            if (replaceRule.charAt(semindex - 2) == '\\' && replaceRule.charAt(semindex - 3) != '\\') break;
                            semindex = replaceRule.indexOf(";", semindex + 1);
                        }
                        catch (IndexOutOfBoundsException e) {
                            if (semindex == 2) break;
                            semindex = replaceRule.indexOf(";", semindex + 1);
                        }
                    }
                    String searchWord = replaceRule.substring(0, semindex);
                    searchWord = searchWord.replace("\\;", ";");
                    searchWord = searchWord.replace("\\\\", "\\");
                    this.logger.trace((Object)("Gesuchtes Wort: " + searchWord));
                    String replaceWord = replaceRule.substring(semindex + 1);
                    replaceWord = replaceWord.replace("\\;", ";");
                    replaceWord = replaceWord.replace("\\\\", "\\");
                    replaceWord = replaceWord.replace("\\n", "\n");
                    this.logger.trace((Object)("Replace Wort: " + replaceWord));
                    if (regex) {
                        aText = aText.replaceAll(searchWord, replaceWord);
                        aText = aText.trim();
                        aSubject = aSubject.replaceAll(searchWord, replaceWord);
                        aSubject = aSubject.trim();
                    } else {
                        aText = aText.replace(searchWord, replaceWord);
                        aText = aText.trim();
                        aSubject = aSubject.replace(searchWord, replaceWord);
                        aSubject = aSubject.trim();
                    }
                    this.logger.debug((Object)("Neuer Alarmtext: " + aText));
                    this.logger.debug((Object)("Neure Betreff: " + aSubject));
                }
                catch (Exception e) {
                    ad.addPluginError("Textersetzung - " + errorcounter, "Fehler in Ersetzungsregel: " + replaceRule + " - Regel konnte nicht angewandt werden");
                    ++errorcounter;
                    this.logger.error((Object)("Fehler in Ersetzungsregel: " + replaceRule + " - Regel konnte nicht angewandt werden"));
                }
                ++n2;
            }
        }
        if (this.pluginData.containsKey("clean") && ((Boolean)((GUIElement)this.pluginData.get("clean")).getValue()).booleanValue()) {
            this.logger.debug((Object)"Alarmtext wird sinnvoll gek\u00fcrzt...");
            aText = Textmod.cleanText(aText, 2);
            aText = Textmod.cleanText(aText, 1);
            this.logger.info((Object)("Gek\u00fcrzter Alarmtext: " + aText));
        }
        ad.setPluginMessage(aText);
        ad.setSubject(aSubject);
        this.logger.debug((Object)"Textmodplugin fertig");
        return ad;
    }

    private static String cleanText(String aText, int nbrOfEquality) {
        StringTokenizer tokenizerLine = new StringTokenizer(aText, "\n\r");
        StringBuffer buf = new StringBuffer();
        while (tokenizerLine.hasMoreTokens()) {
            StringTokenizer tok = new StringTokenizer(tokenizerLine.nextToken(), " \t");
            Object lastWord = null;
            String[] arr = new String[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens()) {
                arr[i++] = tok.nextToken();
            }
            int position = 0;
            while (position < arr.length) {
                block8: {
                    String word;
                    block7: {
                        word = arr[position];
                        if (position == 0) break block7;
                        switch (nbrOfEquality) {
                            case 2: {
                                String B;
                                if (position + 2 >= arr.length) break;
                                String aa = arr[position - 1];
                                String ab = word;
                                String ba = arr[position + 1];
                                String bb = arr[position + 2];
                                String A = String.valueOf(aa) + " " + ab;
                                if (!A.equals(B = String.valueOf(ba) + " " + bb)) break;
                                ++position;
                                break block8;
                            }
                            default: {
                                if (word.equals(arr[position - 1])) break block8;
                            }
                        }
                    }
                    buf.append(word);
                    if (position != arr.length - 1) {
                        buf.append(" ");
                    }
                }
                ++position;
            }
            if (!tokenizerLine.hasMoreTokens()) continue;
            buf.append("\n");
        }
        return buf.toString();
    }

    public int getTimeOut() {
        return 10000;
    }

    public String getDescription() {
        return "Textersetzungsplugin zum l\u00f6schen und ersetzen von W\u00f6rtern im Alarmtext";
    }

    public String getCurrentVersion() {
        return "1.3";
    }

    public String getAuthor() {
        return "firemergency";
    }

    public ImageIcon getIcon48() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/textmod/logo-48.png"));
    }

    public ImageIcon getIcon16() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/textmod/logo-16.png"));
    }

    public String toString() {
        return "Textersetzung";
    }
}

