/*
 * Decompiled with CFR 0.152.
 */
package clipboard;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import server.AbstractPlugin;
import server.AlarmData;
import server.guielements.Dropdown;
import server.guielements.GUIElement;
import server.guielements.Label;

public class Clipboard
extends AbstractPlugin {
    private static final long serialVersionUID = 1L;

    public Clipboard() {
        this.pluginData.put("description", new Label("Dieses Plugin \u00fcbergibt den Alarmtext an <i>Balabolka</i><br>um den Alarmtext volesen zu lassen.<br>Wenn der Modus 'in Datei speichern' gew\u00e4hlt ist, wird der Alarmtext in:<br><b>/files/sound/Alarmtext.txt</b><br>gespeichert.", "", 0));
        ArrayList<String> mode = new ArrayList<String>();
        mode.add("in Zwischenablage kopieren");
        mode.add("in Datei speichern");
        this.pluginData.put("mode", new Dropdown("Alarmtext", "Was mit dem Alarmtext gemacht werden soll", mode, 1));
    }

    public AlarmData run(AlarmData ad) throws Exception {
        this.logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
        GUIElement mode = (GUIElement)this.pluginData.get("mode");
        if (mode == null) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(ad.getPluginMessage()), null);
            this.logger.info((Object)"Alarmtext in Zwischenablage gespeichert");
        } else if (mode.getValue().equals("in Zwischenablage kopieren")) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(ad.getPluginMessage()), null);
            this.logger.info((Object)"Alarmtext in Zwischenablage gespeichert");
        } else {
            File output = new File(String.valueOf(System.getProperty("user.dir")) + "/files/sound/alarmtext.txt");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(output)));
            writer.write(ad.getPluginMessage());
            writer.flush();
            writer.close();
            this.logger.info((Object)String.format("Alarmtext in Datei (%s) gespeichert", output.getAbsolutePath()));
        }
        return ad;
    }

    public int getTimeOut() {
        return 1000;
    }

    public String getDescription() {
        return "Hilfsplugin f\u00fcr Verwendung mit Balabolka";
    }

    public String getCurrentVersion() {
        return "0.2";
    }

    public String getAuthor() {
        return "firEmergency";
    }

    public ImageIcon getIcon48() {
        return null;
    }

    public ImageIcon getIcon16() {
        return null;
    }

    public String toString() {
        return "Text-To-Speech";
    }
}

