/*
 * Decompiled with CFR 0.152.
 */
package mailInput;

import com.sun.mail.imap.IMAPFolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.event.MessageCountAdapter;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.swing.ImageIcon;
import mailInput.StoreTimerTask;
import org.apache.log4j.Logger;
import server.AlarmData;
import server.IAlarmPool;
import server.guielements.Checkbox;
import server.guielements.GUIElement;
import server.guielements.Label;
import server.guielements.Password;
import server.guielements.Text;
import server.guielements.Textarea;
import server.input.AbstractInput;

public class MailInput
extends AbstractInput {
    private static final long serialVersionUID = 1L;
    private String mailserver = "";
    private String username = "";
    private String password = "";
    private String fold = "INBOX";
    private transient Timer timer;
    private transient List<InternetAddress> validMailsAsAddress = new ArrayList<InternetAddress>();
    private List<String> validMails = new ArrayList<String>();
    private boolean isSSL = true;
    private transient Store store;
    private String fallback = "";

    public MailInput(IAlarmPool alarmPool) {
        super(alarmPool);
        this.setName("Mail-Input");
        this.setDaemon(true);
    }

    public MailInput(IAlarmPool alarmPool, int port) {
        super(alarmPool);
        this.setName("Mail-Input");
    }

    public void run() {
        boolean activ = (Boolean)((GUIElement)this.inputData.get("activ")).getValue();
        this.isSSL = true;
        if (!activ) {
            return;
        }
        this.logger = Logger.getLogger(((Object)((Object)this)).getClass());
        this.logger.info((Object)"Mail-\u00dcberwachung gestartet");
        Authenticator auth = null;
        auth = new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailInput.this.username, MailInput.this.password);
            }
        };
        Properties props = new Properties();
        props.setProperty("mail.imaps.host", this.mailserver);
        props.setProperty("mail.imaps.user", this.username);
        props.setProperty("mail.imaps.password", this.password);
        props.setProperty("mail.imaps.auth", "true");
        props.setProperty("mail.imaps.starttls.enable", "true");
        props.setProperty("mail.imaps.socketFactory.port", String.valueOf(993));
        props.setProperty("mail.imaps.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.setProperty("mail.imaps.socketFactory.fallback", "false");
        Session session = Session.getInstance((Properties)props, (Authenticator)auth);
        this.validMailsAsAddress = new ArrayList<InternetAddress>();
        for (String s : this.validMails) {
            try {
                this.validMailsAsAddress.add(new InternetAddress(s));
            }
            catch (AddressException e) {
                this.logger.warn((Object)"Ung\u00fcltiges Mail-Format", (Throwable)e);
            }
        }
        try {
            this.logger.info((Object)("Verbinde zu " + this.mailserver + "@" + this.username + "(imapSSL)... "));
            this.store = this.isSSL ? session.getStore("imaps") : session.getStore("imap");
            this.store.connect();
            this.logger.info((Object)"Verbindung erfolgreich hergestellt");
            IMAPFolder folder = (IMAPFolder)this.store.getFolder(this.fold);
            folder.addMessageCountListener((MessageCountListener)new MessageCountAdapter(){

                public void messagesAdded(MessageCountEvent e) {
                    try {
                        MailInput.this.logger.info((Object)"Neue Nachrichten sind eingetroffen");
                        MailInput.this.newMessageAdded(e);
                    }
                    catch (Exception e1) {
                        MailInput.this.logger.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                }
            });
            folder.open(2);
            this.logger.debug((Object)"Ordner: Schreib/Lese Rechte erhalten");
            this.logger.debug((Object)(String.valueOf(folder.getMessageCount()) + " Nachrichten sind bereits im Postfach"));
            this.logger.debug((Object)("Anzahl berechtiger Absender: " + this.validMailsAsAddress.size()));
            this.logger.debug((Object)"Postfach wird nun abgeh\u00f6rt");
            StoreTimerTask ttStore = new StoreTimerTask(this.store, this.logger);
            Timer timer = new Timer();
            timer.schedule((TimerTask)ttStore, 10000L, 900000L);
            IMAPIdleThread t = new IMAPIdleThread(folder);
            t.run();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void newMessageAdded(MessageCountEvent e) throws MessagingException, IOException {
        Message[] messages;
        Message[] messageArray = messages = e.getMessages();
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            Message message = messageArray[n2];
            Address[] address = message.getFrom();
            if (this.validMailsAsAddress != null) {
                if (this.validMailsAsAddress.contains(address[0])) {
                    this.logger.info((Object)("Eingegangene Email ist berechtigt eine Alamierung auszul\u00f6sen (" + address[0] + ")!"));
                    String subject = "";
                    if (!this.fallback.equals("")) {
                        this.logger.debug((Object)("Verwende Standardalamierungseinheit " + this.fallback));
                        subject = this.fallback.trim();
                    } else {
                        subject = message.getSubject();
                        this.logger.debug((Object)("Folgende Einheiten alamieren: " + subject));
                    }
                    String text = this.getText((Part)message);
                    this.logger.debug((Object)("Messagetext:\n" + text));
                    text = this.cleanText(text);
                    this.logger.debug((Object)("Clean-Messagetext:\n" + text));
                    this.logger.debug((Object)"Text erfolgreich ausgelesen");
                    if (!subject.equals("")) {
                        if (subject.contains(";")) {
                            String[] units = subject.split(";");
                            int j = 0;
                            while (j < units.length) {
                                String unit = units[j];
                                Date date = new Date();
                                this.sendAlarmData(new AlarmData(this.parseAlarm(text, unit), date));
                                this.logger.info((Object)("neuen Alarm f\u00fcr " + unit + " erstellt!"));
                                ++j;
                            }
                        } else {
                            Date date = new Date();
                            this.sendAlarmData(new AlarmData(this.parseAlarm(text, subject), date));
                            this.logger.info((Object)("neuen Alarm f\u00fcr " + subject + " erstellt!"));
                        }
                    }
                } else {
                    this.logger.warn((Object)("Eingegangene Email ist nicht berechtigt eine Alamierung auszul\u00f6sen (" + address[0] + ")!"));
                }
            }
            if (!message.isExpunged()) {
                message.setFlag(Flags.Flag.DELETED, true);
            }
            this.logger.debug((Object)"Nachricht im Postfach gel\u00f6scht!");
            ++n2;
        }
    }

    private String cleanText(String text) {
        while (text.contains("<")) {
            String substring = text.substring(text.indexOf("<"), text.indexOf(">") + 1);
            this.logger.debug((Object)("Tag to be removed: " + substring));
            text = substring.equals("<br>") ? text.replace(substring, "\n") : text.replace(substring, "");
        }
        if (text.contains("&nbsp;")) {
            text = text.replace("&nbsp;", "\n");
        }
        return text;
    }

    private String getText(Part p) throws MessagingException, IOException {
        if (p.isMimeType("text/*")) {
            String s = (String)p.getContent();
            return s;
        }
        if (p.isMimeType("multipart/alternative")) {
            Multipart mp = (Multipart)p.getContent();
            String text = null;
            int i = 0;
            while (i < mp.getCount()) {
                BodyPart bp = mp.getBodyPart(i);
                if (bp.isMimeType("text/plain")) {
                    if (text == null) {
                        text = this.getText((Part)bp);
                    }
                } else if (bp.isMimeType("text/html")) {
                    String s = this.getText((Part)bp);
                    if (s != null) {
                        return s;
                    }
                } else {
                    return this.getText((Part)bp);
                }
                ++i;
            }
            return text;
        }
        if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            int i = 0;
            while (i < mp.getCount()) {
                String s = this.getText((Part)mp.getBodyPart(i));
                if (s != null) {
                    return s;
                }
                ++i;
            }
        }
        return null;
    }

    public String toString() {
        return "Mail-Eingang \u00dcberwachung";
    }

    public String getAuthor() {
        return "FirEmergency";
    }

    public String getCurrentVersion() {
        return "1.0";
    }

    public String getDescription() {
        return "\u00dcberwacht ein eMail-Postfach und alarmiert bei einer neuen Mail.";
    }

    public ImageIcon getIcon16() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/mailInput/logo-16.png"));
    }

    public ImageIcon getIcon48() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/mailInput/logo-48.png"));
    }

    public Hashtable<String, String> parseAlarm(String message, String code) {
        Hashtable<String, String> tab = new Hashtable<String, String>();
        tab.put("address", code);
        tab.put("message", message);
        tab.put("timestamp", String.valueOf(new Date().getTime()));
        this.logger.debug((Object)"Alarm parsed!");
        return tab;
    }

    public void sendAlarmData(AlarmData arg0) {
        this.logger.debug((Object)"Fuege Alarm dem Pool hinzu");
        this.alarmPool.addAlarmData(arg0);
    }

    public void buildGUI() {
        Label element = new Label("Dieses InputPlugin dient zur Anbindung eines Email-Postfachs f\u00fcr Alamierungen.<br>Aus Sicherheitsgr\u00fcnden werden dabei nur IMAPS Konten unterst\u00fctzt,<br>d.h. IMAP Konten die SSL unterst\u00fctzen", "Beschreibung", 0);
        this.inputData.put("description", element);
        element = new Checkbox("Aktivieren", "Schaltet das Alive-Input-Plugin aktiv", 1);
        element.setValue((Object)false);
        this.inputData.put("activ", element);
        element = new Text("Benutzername", "Benutzername des Email-Kontos", 2);
        element.setValue((Object)"Benutzername");
        this.inputData.put("username", element);
        element = new Password("Passwort", "Passwort des Email-Kontos", 3);
        element.setValue((Object)"password");
        this.inputData.put("password", element);
        element = new Text("Posteingangsserver", "Adresse des Posteingangsserver", 4);
        element.setValue((Object)"imap.beispiel.de");
        this.inputData.put("server", element);
        element = new Text("Ordner", "Ordner des Email-Kontos der \u00fcberwacht werden soll", 5);
        element.setValue((Object)"INBOX");
        this.inputData.put("folder", element);
        element = new Textarea("Absender-Email", "Diese Email-Adressen sind berechtigt um Alamierungen auszul\u00f6sen.\nJede Zeile entspricht einer Absenderadresse", 7);
        this.inputData.put("from", element);
        element.setValue((Object)"");
        element = new Text("Alamierungseinheit", "Wird diese Einheit/en eingetragen, so wird immer diese Einheit alamiert.\n\rDer Betreff wird dann als Alamierungsziel ignoriert!\n\rMehrere Einheiten im folgenden Format 12345;23456", 8);
        this.inputData.put("fallback", element);
        element.setValue((Object)"");
    }

    public void setNewParameters() {
        this.validMailsAsAddress = new ArrayList<InternetAddress>();
        this.validMails = new ArrayList<String>();
        if (this.logger == null) {
            this.logger = Logger.getLogger(((Object)((Object)this)).getClass());
        }
        if (this.inputData.get("username") != null) {
            this.username = ((String)((GUIElement)this.inputData.get("username")).getValue()).trim();
        }
        if (this.inputData.get("password") != null) {
            this.password = ((String)((GUIElement)this.inputData.get("password")).getValue()).trim();
        }
        if (this.inputData.get("server") != null) {
            this.mailserver = ((String)((GUIElement)this.inputData.get("server")).getValue()).trim();
        }
        if (this.inputData.get("folder") != null) {
            this.fold = ((String)((GUIElement)this.inputData.get("folder")).getValue()).trim();
        }
        if (this.inputData.get("from") != null) {
            try {
                String[] froms = ((String)((GUIElement)this.inputData.get("from")).getValue()).split("\\s|" + System.getProperty("line.separator"));
                int i = 0;
                while (i < froms.length) {
                    String string = froms[i];
                    if (string != null && !string.equals("")) {
                        if (!this.validateMailAddress(string)) {
                            this.logger.info((Object)"Berechtigungs-Adresse besitzt kein korrektes Format \"adresse@host.domain\"");
                        }
                        this.validMailsAsAddress.add(new InternetAddress(string));
                        this.validMails.add(string.trim());
                    }
                    ++i;
                }
            }
            catch (AddressException e) {
                this.logger.error((Object)("Falsches Email-Format: " + ((GUIElement)this.inputData.get("from")).getValue()));
            }
        }
        if (this.inputData.get("fallback") != null) {
            this.fallback = ((String)((GUIElement)this.inputData.get("fallback")).getValue()).trim();
        }
    }

    public void stopInput() {
        if (this.timer != null) {
            this.timer.cancel();
            this.logger.info((Object)"Mail-Input gestoppt");
        }
    }

    private boolean validateMailAddress(String mailAddress) {
        return mailAddress.contains("@") && mailAddress.substring(mailAddress.indexOf("@")).contains(".");
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.store.close();
        this.logger.debug((Object)"Verbindung zum Postfach beendet!");
    }

    class IMAPIdleThread
    implements Runnable {
        private IMAPFolder folder;

        public IMAPIdleThread(IMAPFolder folder) {
            this.folder = folder;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    MailInput.this.logger.debug((Object)("IDLE Connection to " + this.folder.getName() + " established"));
                    if (!this.folder.isOpen()) {
                        this.folder.open(2);
                    }
                    this.folder.idle(true);
                }
                catch (MessagingException e) {
                    MailInput.this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
                MailInput.this.logger.debug((Object)"Refresh IDLE Connection");
            }
        }
    }
}

