/*
 * Decompiled with CFR 0.152.
 */
package wetterwarnerInput;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import server.AlarmData;
import server.IAlarmPool;
import server.guielements.Checkbox;
import server.guielements.Dropdown;
import server.guielements.GUIElement;
import server.guielements.Text;
import server.guielements.Textarea;
import server.input.AbstractInput;
import wetterwarnerInput.WarningLevel;
import wetterwarnerInput.WarningTyp;

public class WetterInput
extends AbstractInput {
    private static final long serialVersionUID = 1L;
    private URL warningTypeURL;
    private URL dwdURL;
    private Map<String, Map<String, String>> bundesl\u00e4nder;
    private Map<String, String> bundesl\u00e4nderTypWarnings;
    private List<String> landkreise;
    private int nbrWarnings = 0;
    private WarningLevel warningLevel;
    private String landkreis = "Dillingen a.d. Donau";
    private int waitMinutes = 10;
    private Map<String, String> replaceMap = new HashMap<String, String>();
    private List<WarningTyp> warningTypes = new ArrayList<WarningTyp>();
    private String warningText;
    private String von;
    private String bis = "";
    private List<String> codes = new ArrayList<String>();
    private WarningLevel warningLvlOld;
    private int nbrWarningsOld;
    private boolean nbrWarningsFound = false;
    private boolean warningLevelFound = false;
    private boolean firstTime = true;
    private boolean vorwarnung = false;
    private int nbrOfVorwarnungen = 0;
    private transient Timer timer;

    public WetterInput(IAlarmPool alarmPool) {
        super(alarmPool);
        this.setName("Wetterwarner");
    }

    public WetterInput(IAlarmPool alarmPool, int port) {
        super(alarmPool);
        this.setName("Wetterwarner");
    }

    public void run() {
        boolean activ;
        this.logger = Logger.getLogger(((Object)((Object)this)).getClass());
        this.updateURLLists();
        this.warningLvlOld = null;
        this.warningLevelFound = false;
        this.warningText = "";
        this.warningLevel = WarningLevel.BLUE;
        this.firstTime = true;
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (!(activ = ((Boolean)((GUIElement)this.inputData.get("activ")).getValue()).booleanValue())) {
            return;
        }
        this.logger.info((Object)"Wetterwarner gestartet");
        this.logger.info((Object)("Aktualisierungsintervall: " + this.waitMinutes + " Minuten"));
        this.logger.info((Object)("Warnungen f\u00fcr: " + this.landkreis));
        this.setURL(this.landkreis);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new WetterTimer(), 0L, (long)(60000 * this.waitMinutes));
    }

    public String getWarningLevel() {
        return this.warningLevel.getName();
    }

    public int getNumberOfWarnings() {
        return this.nbrWarnings;
    }

    public String getWarnTypes() {
        StringBuffer buf = new StringBuffer();
        for (WarningTyp w : this.warningTypes) {
            buf.append(String.valueOf(w.getName()) + "; ");
        }
        return buf.toString();
    }

    public String getLandkreis() {
        return this.landkreis;
    }

    public void setLandkreis(String landkreis) {
        this.landkreis = landkreis;
        for (String bundesland : this.bundesl\u00e4nder.keySet()) {
            if (!this.bundesl\u00e4nder.get(bundesland).containsKey(landkreis)) continue;
            this.dwdURL = this.createURL(this.bundesl\u00e4nder.get(bundesland).get(landkreis));
            this.warningTypeURL = this.createURL(this.bundesl\u00e4nderTypWarnings.get(bundesland));
            break;
        }
    }

    public URL createURL(String s) {
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void updateNumberOfWarnings(String inputLine) {
        if (inputLine.indexOf("headline") != -1) {
            int a = 0;
            a = inputLine.indexOf("Warnung") - 2;
            String s = inputLine.substring(a, a + 1);
            try {
                a = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                a = 0;
            }
            if (a > 1) {
                this.nbrWarnings = a;
            } else if (a == 0) {
                this.nbrWarnings = 0;
            } else {
                this.nbrWarnings = 1;
                this.nbrWarningsFound = true;
            }
        }
    }

    private void updateWarningLevel(String inputLine) {
        if (inputLine.indexOf("#FFFF00") != -1) {
            this.warningLevel = WarningLevel.YELLOW;
        } else if (inputLine.indexOf("#FA9600") != -1) {
            this.warningLevel = WarningLevel.ORANGE;
        } else if (inputLine.indexOf("#FF0000") != -1) {
            this.warningLevel = WarningLevel.RED;
        } else if (inputLine.indexOf("#AF0064") != -1) {
            this.warningLevel = WarningLevel.PURPLE;
        } else if (inputLine.indexOf("#CC99FF") != -1) {
            this.warningLevel = WarningLevel.PINK;
        } else {
            return;
        }
        this.warningLevelFound = true;
    }

    private void updateTypesOfWarnings() {
        String landkreisTmp = this.landkreis;
        if (this.replaceMap.containsKey(this.landkreis)) {
            landkreisTmp = this.replaceMap.get(this.landkreis);
        }
        try {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(this.warningTypeURL.openStream(), "UTF-8"));
            while ((inputLine = in.readLine()) != null && inputLine.indexOf("</html>") == -1) {
                if (inputLine.indexOf(">" + landkreisTmp + "<") == -1) continue;
                this.warningTypes = new ArrayList<WarningTyp>();
                this.logger.trace((Object)("InputLine: " + inputLine));
                inputLine = inputLine.substring(inputLine.indexOf(landkreisTmp), inputLine.length() - 1);
                this.logger.trace((Object)("InputLine: " + inputLine));
                inputLine = inputLine.substring(0, inputLine.indexOf("target"));
                this.logger.trace((Object)("InputLine: " + inputLine));
                if (inputLine.indexOf("pic_01") != -1) {
                    this.warningTypes.add(WarningTyp.WIND);
                }
                if (inputLine.indexOf("pic_02") != -1) {
                    this.warningTypes.add(WarningTyp.RAIN);
                }
                if (inputLine.indexOf("pic_03") != -1) {
                    this.warningTypes.add(WarningTyp.THUNDERSTORM);
                }
                if (inputLine.indexOf("pic_05") != -1) {
                    this.warningTypes.add(WarningTyp.SNOW);
                }
                if (inputLine.indexOf("pic_04") != -1) {
                    this.warningTypes.add(WarningTyp.ICE);
                }
                if (inputLine.indexOf("pic_06") != -1) {
                    this.warningTypes.add(WarningTyp.FREEZE);
                }
                if (inputLine.indexOf("pic_07") == -1) continue;
                this.warningTypes.add(WarningTyp.FOG);
            }
            this.logger.debug((Object)("Typen: " + Arrays.toString(this.warningTypes.toArray())));
        }
        catch (Exception e) {
            this.logger.error((Object)"Fehler beim Abruf der Warntypen", (Throwable)e);
        }
    }

    public void updateWeatherSituation() {
        try {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(this.dwdURL.openStream(), "UTF-8"));
            this.nbrWarningsFound = false;
            this.warningLevelFound = false;
            this.vorwarnung = false;
            this.nbrOfVorwarnungen = 0;
            StringBuffer buf = new StringBuffer();
            while ((inputLine = in.readLine()) != null && inputLine.indexOf("</html>") == -1) {
                if (!this.nbrWarningsFound) {
                    this.updateNumberOfWarnings(inputLine);
                }
                if (!this.warningLevelFound) {
                    this.updateWarningLevel(inputLine);
                }
                if (inputLine.indexOf("</p>") == -1) continue;
                if ((inputLine = inputLine.replace("</p>", "")).startsWith("g\u00fcltig von: ")) {
                    this.von = inputLine.replaceAll("g\u00fcltig von: ", "");
                }
                if (inputLine.startsWith("bis: ")) {
                    this.bis = inputLine.replaceAll("bis: ", "");
                }
                if (inputLine.indexOf("VORWARNUNG") != -1) {
                    this.vorwarnung = true;
                    ++this.nbrOfVorwarnungen;
                    this.logger.debug((Object)"Warnung enth\u00e4lt eine VORWARNUNG");
                }
                buf.append(String.valueOf(inputLine) + "\n");
            }
            in.close();
            if (!this.warningLevelFound) {
                this.warningLevel = WarningLevel.BLUE;
            }
            if (this.vorwarnung) {
                this.warningLevel = WarningLevel.VOR;
            }
            this.logger.debug((Object)("Warnlevel: " + (Object)((Object)this.warningLevel)));
            this.warningText = buf.toString();
            if (this.warningLevel == WarningLevel.BLUE) {
                this.warningText = "Keine Warnungen";
                this.nbrWarnings = 0;
            }
            this.logger.debug((Object)("Anzahl Warnungen: " + this.nbrWarnings));
            this.logger.debug((Object)("Anzahl an VORWARNUNGEN: " + this.nbrOfVorwarnungen));
            if (this.nbrWarnings != 0) {
                this.updateTypesOfWarnings();
            } else {
                this.warningTypes.clear();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"Fehler im WetterwarnInputPlugin", (Throwable)e);
        }
    }

    public void updateURLLists() {
        this.bundesl\u00e4nder = new HashMap<String, Map<String, String>>();
        this.landkreise = new ArrayList<String>();
        this.replaceMap = new HashMap<String, String>();
        File f = new File("");
        f = new File(String.valueOf(f.getAbsolutePath()) + "/files/weather");
        this.logger.debug((Object)("Pfad: " + f.getAbsolutePath()));
        int count = 0;
        File[] fileArray = f.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file != null && file.getName().endsWith(".txt")) {
                String bundesland = file.getName().replace(".txt", "");
                if (bundesland.matches("Bundesl\u00e4nder")) {
                    this.bundesl\u00e4nderTypWarnings = this.importFile(file, true);
                } else {
                    this.bundesl\u00e4nder.put(bundesland, this.importFile(file, false));
                }
                ++count;
            }
            ++n2;
        }
        this.logger.debug((Object)("Dateien importiert: " + count));
        for (String bundesland : this.bundesl\u00e4nder.keySet()) {
            this.landkreise.addAll(this.bundesl\u00e4nder.get(bundesland).keySet());
        }
        Collections.sort(this.landkreise);
    }

    private void setURL(String landkreis) {
        for (String bundesland : this.bundesl\u00e4nder.keySet()) {
            try {
                if (!this.bundesl\u00e4nder.get(bundesland).containsKey(landkreis)) continue;
                this.dwdURL = new URL(this.bundesl\u00e4nder.get(bundesland).get(landkreis));
                this.logger.debug((Object)("URL-DWD: " + this.dwdURL));
                this.warningTypeURL = new URL(this.bundesl\u00e4nderTypWarnings.get(bundesland));
                this.logger.debug((Object)("URL-DWD-Bundesland: " + this.warningTypeURL));
            }
            catch (MalformedURLException e) {
                this.logger.error((Object)"DWD-URL konnte nicht generiert werden", (Throwable)e);
            }
        }
    }

    private Map<String, String> importFile(File f, boolean bundesl\u00e4nder) {
        HashMap<String, String> landkreise = new HashMap<String, String>();
        try {
            String input;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            boolean firstOne = true;
            while ((input = in.readLine()) != null) {
                String[] arr = input.split("-#-");
                if (arr.length != 2) continue;
                if (firstOne) {
                    if (!bundesl\u00e4nder) {
                        arr[0] = arr[0].substring(1).trim();
                    }
                    firstOne = false;
                }
                if (arr[0].indexOf("###") != -1) {
                    String[] tmp = arr[0].split("###");
                    this.logger.debug((Object)("Ersetzung gefunden: " + tmp[0] + "=" + tmp[1]));
                    this.replaceMap.put(tmp[0], tmp[1]);
                    arr[0] = tmp[0];
                }
                landkreise.put(arr[0].trim(), arr[1].trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return landkreise;
    }

    public String toString() {
        return "Wetterwarner";
    }

    public String getAuthor() {
        return "firEmergency";
    }

    public String getCurrentVersion() {
        return "1.1";
    }

    public String getDescription() {
        return "Benachrichtigung wenn neue Wetterwarnungen eingehen.";
    }

    public ImageIcon getIcon16() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/wetterwarnerInput/logo-16.png"));
    }

    public ImageIcon getIcon48() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/wetterwarnerInput/logo-48.png"));
    }

    public Hashtable<String, String> parseAlarm(String message, String code) {
        Hashtable<String, String> tab = new Hashtable<String, String>();
        tab.put("address", code);
        tab.put("district", this.landkreis);
        tab.put("weatherWarnLevel", this.warningLevel.getName());
        tab.put("weatherNbrWarnings", String.valueOf(this.nbrWarnings));
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.warningTypes.size()) {
            buf.append(this.warningTypes.get(i).getName());
            if (i != this.warningTypes.size() - 1) {
                buf.append(";");
            }
            ++i;
        }
        tab.put("weatherWarningTyps", buf.toString());
        this.logger.debug((Object)("Warntypen: " + buf.toString()));
        tab.put("message", message);
        tab.put("endTime", this.bis);
        tab.put("startTime", this.von);
        tab.put("vorwarnung", this.vorwarnung ? "ja" : "nein");
        tab.put("nbrVorwarnungen", String.valueOf(this.nbrOfVorwarnungen));
        tab.put("dwdURL", this.dwdURL.getPath());
        return tab;
    }

    public void sendAlarmData(AlarmData arg0) {
        this.alarmPool.addAlarmData(arg0);
        this.logger.info((Object)"Neue Wetterwarnung hinzugef\u00fcgt");
    }

    public void buildGUI() {
        this.logger.debug((Object)"Lade URLs...");
        this.updateURLLists();
        this.logger.debug((Object)("Anzahl Landkreise: " + this.landkreise.size()));
        Checkbox element = new Checkbox("Aktivieren", "Schaltet das Wetterwarn-Input-Plugin aktiv", 0);
        element.setValue((Object)false);
        this.inputData.put("activ", element);
        element = new Dropdown("Landkreis", "W\u00e4hlen Sie hier den Landkreis f\u00fcr Ihre Warnungen aus", this.landkreise, 1);
        element.setValue((Object)"Dillingen a.d. Donau");
        this.inputData.put("landkreis", element);
        element = new Text("Intervall in Minuten", "Alle X Minuten wird die Warnlage aktualisiert", 2);
        element.setValue((Object)"10");
        this.inputData.put("intervall", element);
        element = new Checkbox("Gleiches Warnlevel blockieren", "Das gleiche Warnlevel wird blockiert, falls es sich nicht ge\u00e4ndert hat", 3);
        element.setValue((Object)true);
        this.inputData.put("blockEqual", element);
        element = new Textarea("Codes der zu alarmierenden Einheiten", "Geben Sie hier die Einheitencodes an. Jede Zeile entspricht einem Code", 4);
        this.inputData.put("codes", element);
    }

    public void setNewParameters() {
        String[] lines;
        try {
            this.waitMinutes = Integer.parseInt((String)((GUIElement)this.inputData.get("intervall")).getValue());
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)("Falsches Intervall-Format: " + ((GUIElement)this.inputData.get("intervall")).getValue()));
        }
        this.landkreis = (String)((GUIElement)this.inputData.get("landkreis")).getValue();
        this.codes = new ArrayList<String>();
        if (((GUIElement)this.inputData.get("codes")).getValue() == null) {
            return;
        }
        String[] stringArray = lines = ((String)((GUIElement)this.inputData.get("codes")).getValue()).split("\\r?\\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String code = stringArray[n2];
            this.codes.add(code.trim());
            ++n2;
        }
    }

    public void stopInput() {
        if (this.timer != null) {
            this.timer.cancel();
            this.logger.info((Object)"Wetterwarner-Input gestoppt");
            this.firstTime = true;
        }
    }

    class WetterTimer
    extends TimerTask {
        WetterTimer() {
        }

        @Override
        public void run() {
            WetterInput.this.logger.debug((Object)"Nach neuen Warnungen wird gesucht...");
            if (WetterInput.this.dwdURL == null) {
                WetterInput.this.logger.warn((Object)"Kein Landkreis ausgew\u00e4hlt");
                return;
            }
            WetterInput.this.updateWeatherSituation();
            if (WetterInput.this.warningLvlOld == null) {
                WetterInput.this.logger.info((Object)"Erster Durchlauf. Keine Alarmierung");
                WetterInput.this.warningLvlOld = WetterInput.this.warningLevel;
                WetterInput.this.nbrWarningsOld = 0;
                return;
            }
            if (WetterInput.this.nbrWarningsOld != WetterInput.this.nbrWarnings || WetterInput.this.warningLvlOld != WetterInput.this.warningLevel) {
                if (WetterInput.this.warningLvlOld == WetterInput.this.warningLevel && ((Boolean)((GUIElement)WetterInput.this.inputData.get("blockEqual")).getValue()).booleanValue() && !WetterInput.this.firstTime) {
                    WetterInput.this.logger.info((Object)"Warnlevel hat sich nicht ge\u00e4ndert");
                } else {
                    if (WetterInput.this.firstTime) {
                        WetterInput.this.logger.debug((Object)"Erste Warnmeldung seit Neustart");
                        WetterInput.this.firstTime = false;
                    }
                    if (WetterInput.this.warningLevel == WarningLevel.PINK) {
                        WetterInput.this.warningTypes.add(WarningTyp.HEAT);
                    }
                    WetterInput.this.logger.info((Object)"Warnsituation hat sich ge\u00e4ndert. Alarmierung wird ausgef\u00fchrt");
                    Date date = new Date();
                    for (String code : WetterInput.this.codes) {
                        WetterInput.this.sendAlarmData(new AlarmData(WetterInput.this.parseAlarm(WetterInput.this.warningText, code), date));
                    }
                }
            }
            WetterInput.this.warningLvlOld = WetterInput.this.warningLevel;
            WetterInput.this.nbrWarningsOld = WetterInput.this.nbrWarnings;
        }
    }
}

