/*
 * Decompiled with CFR 0.152.
 */
package wetterwarnerInput;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import wetterwarnerInput.WarningLevel;
import wetterwarnerInput.WarningTyp;

public class Test {
    private static final long serialVersionUID = 1L;
    private static URL dwdURL;
    private static Map<String, Map<String, String>> bundesl\u00e4nder;
    private static Map<String, String> bundesl\u00e4nderTypWarnings;
    private static List<String> landkreise;
    private static int nbrWarnings;
    private static WarningLevel warningLevel;
    private static String landkreis;
    private static int waitMinutes;
    private static List<WarningTyp> warningTypes;
    private static String warningText;
    private static String von;
    private static String bis;
    private static List<String> codes;
    private static WarningLevel warningLvlOld;
    private static int nbrWarningsOld;
    private static boolean nbrWarningsFound;
    private static boolean warningLevelFound;
    private static boolean firstTime;
    private static URL warningTypeURL;

    static {
        nbrWarnings = 0;
        landkreis = "Breisgau-Hochschwarzwald";
        waitMinutes = 10;
        warningTypes = new ArrayList<WarningTyp>();
        bis = "";
        codes = new ArrayList<String>();
        nbrWarningsFound = false;
        warningLevelFound = false;
        firstTime = true;
    }

    public static void main(String[] args) throws Exception {
        warningTypeURL = new URL("http://www.dwd.de/bvbw/appmanager/bvbw/dwdwwwDesktop?_nfpb=true&_windowLabel=T14600649251144330032285&_urlType=action&T14600649251144330032285_LAND_CODE=SU&T14600649251144330032285_HEIGHT=x&T14600649251144330032285_TIME=x&T14600649251144330032285_WARNING_TYPE=0&T14600649251144330032285_TABLE_VIEW=true&T14600649251144330032285_MAP_VIEW=false&T14600649251144330032285_MOVIE_VIEW=false&T14600649251144330032285_WEEKLY_REPORT_VIEW=false&T14600649251144330032285_STATIC_CONTENT_VIEW=false&T14600649251144330032285_SHOW_TIME_SEL=true&T14600649251144330032285_SHOW_HEIGHT_SEL=true&_pageLabel=_dwdwww_wetter_warnungen_warnungen");
        Test.updateTypesOfWarnings();
        System.err.println(warningTypes);
    }

    private static void updateTypesOfWarnings() {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(warningTypeURL.openStream(), "UTF-8"));
            while (true) {
                String inputLine;
                if ((inputLine = in.readLine()) == null || inputLine.indexOf("</html>") != -1) {
                    return;
                }
                if (inputLine.indexOf(">" + landkreis + "<") == -1) continue;
                warningTypes = new ArrayList<WarningTyp>();
                inputLine = inputLine.substring(inputLine.indexOf(landkreis), inputLine.length() - 1);
                if ((inputLine = inputLine.substring(0, inputLine.indexOf("target"))).indexOf("pic_01") != -1) {
                    warningTypes.add(WarningTyp.WIND);
                }
                if (inputLine.indexOf("pic_02") != -1) {
                    warningTypes.add(WarningTyp.RAIN);
                }
                if (inputLine.indexOf("pic_03") != -1) {
                    warningTypes.add(WarningTyp.THUNDERSTORM);
                }
                if (inputLine.indexOf("pic_05") != -1) {
                    warningTypes.add(WarningTyp.SNOW);
                }
                if (inputLine.indexOf("pic_04") != -1) {
                    warningTypes.add(WarningTyp.ICE);
                }
                if (inputLine.indexOf("pic_06") != -1) {
                    warningTypes.add(WarningTyp.FREEZE);
                }
                if (inputLine.indexOf("pic_07") == -1) continue;
                warningTypes.add(WarningTyp.FOG);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private static void updateWarningLevel(String inputLine) {
        if (inputLine.indexOf("#FFFF00") != -1) {
            warningLevel = WarningLevel.YELLOW;
        } else if (inputLine.indexOf("#FA9600") != -1) {
            warningLevel = WarningLevel.ORANGE;
        } else if (inputLine.indexOf("#FF0000") != -1) {
            warningLevel = WarningLevel.RED;
        } else if (inputLine.indexOf("#AF0064") != -1) {
            warningLevel = WarningLevel.PURPLE;
        } else if (inputLine.indexOf("#CC99FF") != -1) {
            warningLevel = WarningLevel.PINK;
        } else {
            return;
        }
        System.err.println(true);
        warningLevelFound = true;
    }

    private static void updateNumberOfWarnings(String inputLine) {
        if (inputLine.indexOf("headline") != -1) {
            int a = 0;
            a = inputLine.indexOf("Warnung") - 2;
            String s = inputLine.substring(a, a + 1);
            try {
                a = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                a = 0;
            }
            if (a > 1) {
                nbrWarnings = a;
            } else if (a == 0) {
                nbrWarnings = 0;
            } else {
                nbrWarnings = 1;
                nbrWarningsFound = true;
            }
        }
    }

    public static void updateURLLists() {
        bundesl\u00e4nder = new HashMap<String, Map<String, String>>();
        landkreise = new ArrayList<String>();
        File f = new File("");
        f = new File("E:/Projekt/firEmergency/files/weather");
        System.out.println("Pfad: " + f.getAbsolutePath());
        int count = 0;
        File[] fileArray = f.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file != null && file.getName().endsWith(".txt")) {
                String bundesland = file.getName().replace(".txt", "");
                if (bundesland.matches("Bundesl\u00e4nder")) {
                    bundesl\u00e4nderTypWarnings = Test.importFile(file, true);
                } else {
                    bundesl\u00e4nder.put(bundesland, Test.importFile(file, false));
                }
                ++count;
            }
            ++n2;
        }
        System.out.println("Dateien importiert: " + count);
        for (String bundesland : bundesl\u00e4nder.keySet()) {
            landkreise.addAll(bundesl\u00e4nder.get(bundesland).keySet());
        }
        Collections.sort(landkreise);
    }

    private static Map<String, String> importFile(File f, boolean bundesl\u00e4nder) {
        HashMap<String, String> landkreise = new HashMap<String, String>();
        try {
            String input;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            boolean firstOne = true;
            while ((input = in.readLine()) != null) {
                String[] arr = input.split("-#-");
                if (arr.length != 2) continue;
                if (firstOne) {
                    if (!bundesl\u00e4nder) {
                        arr[0] = arr[0].substring(1).trim();
                    }
                    firstOne = false;
                }
                landkreise.put(arr[0].trim(), arr[1].trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return landkreise;
    }
}

