/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import server.AbstractPlugin;
import server.AdditinalJarPool;
import server.Pipeline;
import server.PluginController;
import server.PluginPool;
import server.data.DataManagement;
import server.data.Group;
import server.data.Person;
import server.data.User;
import server.data.UserManagement;
import server.guielements.GUIElement;
import starter.Starter;
import starter.StarterLicenseAddition;

public class ExportConfigData {
    private static DataManagement datamanagement;
    private static UserManagement usermanagement;
    private static String configdir;
    private static AdditinalJarPool addJarPool;
    private static Logger logger;
    private static PluginPool pluginPool;
    private static final String newline;

    static {
        newline = System.getProperty("line.separator");
    }

    public static void main(String[] args) {
        Starter.setLicenseType((StarterLicenseAddition.LicenseTypes)StarterLicenseAddition.LicenseTypes.PREMIUM);
        logger = Logger.getLogger((String)"ExportConfigData");
        addJarPool = new AdditinalJarPool();
        addJarPool.startJarInit();
        configdir = DataManagement.getOSIndependentPath((String)(String.valueOf(System.getProperty("user.dir")) + "/Config/"));
        logger.debug((Object)("Config Directory: " + configdir));
        pluginPool = new PluginPool();
        pluginPool.startPluginInit();
        logger.debug((Object)"Instanziiere...");
        datamanagement = new DataManagement(configdir);
        usermanagement = new UserManagement(datamanagement);
        String password = JOptionPane.showInputDialog(null, (Object)"Bitte Administratorpasswort eingeben");
        User admin = usermanagement.loginUser("Admin", password);
        if (admin == null) {
            JOptionPane.showMessageDialog(null, "Passwort falsch! Daten k\u00f6nnen nicht exportiert werden.");
            return;
        }
        List users = usermanagement.getAllUsers();
        File backup = new File(String.valueOf(System.getProperty("user.dir")) + "/backup/");
        if (!backup.exists()) {
            backup.mkdir();
        }
        for (User u : users) {
            try {
                ExportConfigData.wirteUserFile(u);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void wirteUserFile(User u) throws IOException {
        File file = new File("backup/" + u.getName() + ".txt");
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        FileWriter fw = new FileWriter(file);
        fw.write("Adressbuch" + newline);
        fw.write("firstname, ");
        fw.write("lastname, ");
        for (String field : u.getAddressbookfields()) {
            fw.write(String.valueOf(field) + ", ");
        }
        fw.write(newline);
        for (Person p : u.getAddressbook().values()) {
            fw.write(String.valueOf(p.getFirstName()) + ", ");
            fw.write(String.valueOf(p.getLastName()) + ", ");
            for (String field : u.getAddressbookfields()) {
                fw.write(String.valueOf(p.getDataByField(field)) + ", ");
            }
            fw.write(newline);
        }
        fw.write(newline);
        fw.write(newline);
        fw.write(newline);
        for (Group g : u.getGroups()) {
            fw.write("Einheit: Name: " + g.getName() + " Code: " + g.getCode() + newline);
            for (Pipeline pl : g.getPipelines()) {
                if (pl.countPluginControllers() <= 0) continue;
                for (PluginController pc : pl.getListofPluginController()) {
                    ExportConfigData.writePluginController(pc, fw);
                }
            }
        }
        fw.flush();
        fw.close();
    }

    private static void writePluginController(PluginController pc, FileWriter fw) throws IOException {
        fw.write("Plugin: " + pc.getPluginName() + newline);
        AbstractPlugin plugin = pc.getPlugin();
        for (GUIElement ge : plugin.getSortedListofGUIElements()) {
            if (ge.getValue() == null) continue;
            fw.write(String.valueOf(ge.getLabel()) + ": " + ge.getValue().toString() + newline);
        }
        fw.write(newline);
        fw.write(newline);
        if (pc.getChildren().size() > 0) {
            for (PluginController innerPC : pc.getChildren()) {
                ExportConfigData.writePluginController(innerPC, fw);
            }
        }
    }
}

