/*
 * Decompiled with CFR 0.152.
 */
package prowl;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import net.sourceforge.prowl.api.DefaultProwlEvent;
import net.sourceforge.prowl.api.ProwlClient;
import net.sourceforge.prowl.api.ProwlEvent;
import net.sourceforge.prowl.exception.ProwlException;
import org.apache.log4j.Logger;
import server.AbstractPlugin;
import server.AlarmData;
import server.guielements.Dropdown;
import server.guielements.GUIElement;
import server.guielements.Label;
import server.guielements.PersonSelectBox;
import server.guielements.Text;

public class Prowl
extends AbstractPlugin {
    private static final long serialVersionUID = 1L;

    public Prowl() {
        this.retrys = 0;
        this.pluginData.put("description", new Label("Plugin alamiert die ausgew\u00e4hlte Personen via iPhone-Push mit Prowl<br>F\u00fcr mehr Informationen: http://www.prowlapp.com/", "", 0));
        ArrayList<String> priority = new ArrayList<String>();
        priority.add("Gering");
        priority.add("Moderat");
        priority.add("Mittel");
        priority.add("Hoch");
        priority.add("Notfall");
        this.pluginData.put("priority", new Dropdown("Priorit\u00e4t", "Push-Priorit\u00e4t: Von gering bis Notfall", priority, 1));
        this.pluginData.put("application", new Text("Alarmname", "Wird in Prowl als Applikation angezeigt", 2));
        this.pluginData.put("person-iphone", new PersonSelectBox("Personen", "IPhone-Prowl-Key", 3, "iphone"));
    }

    public AlarmData run(AlarmData ad) throws Exception {
        this.logger = Logger.getLogger(((Object)((Object)this)).getClass());
        this.logger.debug((Object)"Pushdata:");
        String application = (String)((GUIElement)this.pluginData.get("application")).getValue();
        if (application.equals("N/A") || application.equals("")) {
            application = "firEmergency";
        }
        this.logger.debug((Object)("application: " + application));
        String event = ad.getParameter("subject");
        if (event.equals("N/A") || event.equals("")) {
            event = "Einsatzalarmierung";
        }
        this.logger.debug((Object)("event: " + event));
        String prio = (String)((GUIElement)this.pluginData.get("priority")).getValue();
        this.logger.debug((Object)("priority: " + prio));
        String alarmText = ad.getPluginMessage();
        this.logger.debug((Object)("description: " + alarmText));
        int priority = prio.matches("Gering") ? -2 : (prio.matches("Moderat") ? -1 : (prio.matches("Mittel") ? 0 : (prio.matches("Hoch") ? 1 : 2)));
        if (this.personsToAlarm.get("iphone") == null || ((List)this.personsToAlarm.get("iphone")).size() == 0) {
            this.logger.error((Object)"iPhone-Prowl Liste enth\u00e4lt keine Eintr\u00e4ge >> Niemand kann alarmiert werden");
            ad.addPluginError("Prowl", "iPhone-Prowl Liste enth\u00e4lt keine Eintr\u00e4ge");
        } else {
            for (String apiKey : (List)this.personsToAlarm.get("iphone")) {
                this.pushAlarm(apiKey, application, event, alarmText, priority, ad);
            }
        }
        return ad;
    }

    private void pushAlarm(String apiKey, String application, String event, String description, int priority, AlarmData ad) {
        this.logger.debug((Object)("Push f\u00fcr API-Key: " + apiKey));
        ProwlClient pClient = new ProwlClient();
        DefaultProwlEvent pEvent = new DefaultProwlEvent(apiKey, application, event, description, priority);
        try {
            String result = pClient.pushEvent((ProwlEvent)pEvent);
            this.logger.info((Object)("Senden an " + apiKey + ": " + result));
            this.logger.debug((Object)"Push erfolgreich!");
        }
        catch (ProwlException e) {
            this.logger.debug((Object)"Fehler beim Push");
            this.logger.debug((Object)("Response Code: " + e.getMessage() + "(" + e.getResponseCode() + ")"));
            ad.addPluginError("iPhone", e.getMessage());
        }
    }

    public int getTimeOut() {
        return 90000;
    }

    public String getDescription() {
        return "Alamierungen von IPhones via Prowl";
    }

    public String getCurrentVersion() {
        return "0.8";
    }

    public String getAuthor() {
        return "Stefan Beutlrock";
    }

    public ImageIcon getIcon16() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/prowl/logo-16.png"));
    }

    public ImageIcon getIcon48() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("/prowl/logo-48.png"));
    }

    public String toString() {
        return "IPhone (Prowl)";
    }
}

