#ifndef PLUGINTHREAD_H_
#define PLUGINTHREAD_H_

#include "SocketServer.h"

/*
 * PluginThread
 */

class PluginThread : public ThreadBase
{
public:
	PluginThread(int LOCKNUM, std::string dllfile,XMLNode *pConfig=NULL);
	PluginThread();
	virtual ~PluginThread();
	virtual void *Thread() ;
	bool initPlugin(int LOCKNUM, std::string,XMLNode *pConfig=NULL) ;
	MonitorBlockingSignal m_signal ;
	virtual void addResult(ModuleResultBase* pRes) ;
	bool m_bStop ;

private:
	MonitorPlugIn* m_plugin ;
	MODULERESULTSET m_queue ;
	DLLFactory<MonitorPlugInFactory>* dll ;
} ;

typedef std::vector<PluginThread*> tMonitorPluginThreadVector ;
/**
 * @brief Verwaltet alle Nicht-Audio Plugins
 */

class MonitorPluginsManager
{
public:
	MonitorPluginsManager() ;
	virtual ~MonitorPluginsManager() ;
	bool addModule(PluginThread* pThread) ;
	bool removeModule(PluginThread* pThread);
	bool dispatchResult(ModuleResultBase *pRes) ;
	bool loadPlugin(std::string dllfile, XMLNode *pConfig);
	bool loadPluginsFromConfigNode(XMLNode *pConfig);

protected:
	MEMLOCK m_MemLock ;
	tMonitorPluginThreadVector m_Modules ;
	bool m_bStop ;
};

MonitorPluginsManager& GetPluginsManager() ;


#endif /*PLUGINTHREAD_H_*/
