Public Class AlarmLib
    Private parameter As Alarmparameter
    Sub New(ByVal Aparameter As Alarmparameter)
        parameter = Aparameter
    End Sub


    Private Function doalarm(ByVal pagerstring As String) As Boolean

        Dim sqlconn As New System.Data.Odbc.OdbcConnection
        sqlconn.ConnectionString = parameter.connectionstring
        ' Connection ffnen
        Try
            sqlconn.Open()
            'MsgBox(sqlconn.State.ToString)
        Catch ex As Exception
            'MsgBox(ex.Message)
        End Try

        Dim alarmdaten As New alarm_dll.Alarmdaten()
        Dim fehlertext As String = String.Empty
        Dim originalmeldung As String = String.Empty
        Dim logging As New alarm_dll.alarmlog()


        'splitten
        Dim splitter As New alarm_dll.SplitPagerString()
        splitter.SplitPagerString(sqlconn, pagerstring, alarmdaten, fehlertext, originalmeldung)

        'rohdaten protokollieren
        Dim rohdatenprot As New alarm_dll.AlarmProtokoll()
        rohdatenprot.rohdatenprotokoll(sqlconn, pagerstring)


        'aufbereitete alarmdaten protokollieren
        Dim prot As New alarm_dll.AlarmProtokoll()
        prot.Protokollieren(sqlconn, alarmdaten)

        'drucken
        Dim druck As New alarm_dll.Alarmdruck()
        Dim druckername() As String
        Dim druckersettingsbuffer As String = String.Empty
        Select Case alarmdaten.ric
            Case "01A", "01B", "01C", "01D"
                druckersettingsbuffer = parameter.DruckerEinzelruf
            Case "02A", "02B", "02C", "02D"
                druckersettingsbuffer = parameter.DruckerFluh
            Case "03A", "03B", "03C", "03D"
                druckersettingsbuffer = parameter.DruckerRieden
            Case "04A", "04B", "04C", "04D"
                druckersettingsbuffer = parameter.DruckerStadt
            Case "05A", "05B", "05C", "05D"
                druckersettingsbuffer = parameter.DruckerVkl
            Case Else
        End Select

        'druckersettingsbuffer mitloggen
        logging.schreiben("Druckersettingsbuffer: " & druckersettingsbuffer)
        logging.leerzeile()

        druckername = Strings.Split(druckersettingsbuffer, ";")

        'Druckfile anlegen und prfen ob entsprechende Bilddatei vorhanden ist, ansonsten ganze Strasse drucken
        Dim druckfile As String = parameter.BildPfad & alarmdaten.strasse & alarmdaten.hausnummer & ".jpg"
        If System.IO.File.Exists(druckfile) = False Then
            druckfile = parameter.BildPfad & alarmdaten.strasse & "0.jpg"
            If System.IO.File.Exists(druckfile) = False Then
                druckfile = parameter.BildPfad & "keinbild.jpg"
            End If
        End If

        Dim timestampbuffer() As String = Strings.Split(alarmdaten.timestamp, " ")
        Dim alarmtext As String = String.Empty

        alarmtext = "Einsatznummer: " & alarmdaten.einsatznummer & vbCrLf & "Datum: " & timestampbuffer(1) & vbCrLf & "Uhrzeit: " & timestampbuffer(0) & " Uhr" & vbCrLf & vbCrLf & "Einsatzmeldung: " & originalmeldung

        'Zusatzinfo aus Tabelle auslesen und drucktext generieren
        Dim zusatzinfo As New alarm_dll.zusatzinfo()
        Dim zusatzinfotextdruck As String = String.Empty
        zusatzinfo.zusatzinfolesen(sqlconn, alarmdaten, zusatzinfotextdruck)

        'Ausdrucken

        For i As Integer = 1 To druckername.Length
            logging.schreiben("Druckername " & i & ": " & druckername(i - 1))
            logging.leerzeile()
            Try
                druck.Drucken(druckfile, alarmtext, fehlertext, zusatzinfotextdruck, alarmdaten, druckername(i - 1))
            Catch ex As Exception
                logging.schreiben(ex.Message)
                logging.leerzeile()
            End Try
        Next

        'mail senden
        Dim alarmmailsenden As New alarm_dll.alarmmail()
        alarmmailsenden.mailsenden(pagerstring, parameter.host, parameter.port, parameter.login, parameter.password, parameter.fromadresse, parameter.toadresse, parameter.tosmsadresse)

        Return True
    End Function
    Private Sub ueberwachung()
        Dim com As New alarm_dll.schnittstelle()

        Dim serial_port As New System.IO.Ports.SerialPort()

        Dim zeichenbuffer As String = String.Empty
        Do
            com.Receive(serial_port, zeichenbuffer)
            doalarm(zeichenbuffer)
        Loop
    End Sub

    Public Sub Start()
        Dim Thread As New Threading.Thread(AddressOf ueberwachung)
        Thread.Start()
        Thread.IsBackground = True
    End Sub

End Class
